//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 14 lights, 42 materials and 979 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 10/31/1999    (31.10.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <     45.350,     336.332,      48.580>
  direction <        0.0,         0.0,      0.8688> // Aperture is 1.04 degrees
  sky       <   -0.06028,    -0.41723,     0.90680> // Use right handed-system (rotated by 25.00 degrees)!
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <    190.506,     317.730,      37.969>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <      0.000,      -0.100,       0.000>
  direction <        0.0,         0.0,      1.8660> // Aperture is 0.52 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.000,       0.000,       0.000>
}

*/

/*
camera {  //  Camera SpotCam002
  location  <     77.912,     339.458,      57.164> // Attached to Lens Flare
  direction <        0.0,         0.0,      1.8660> // Aperture is 0.52 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     76.919,     339.458,      57.045> // Following Lens Flare
}

*/

/*
camera {  //  Camera SpotCam003
  location  <     61.857,     345.953,      34.257> // Attached to Sig Spot
  direction <        0.0,         0.0,      1.5089> // Aperture is 0.64 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     63.840,     341.365,      34.371> // Following Sig Spot
}

*/

/*
camera {  //  Camera SpotCam004
  location  <      0.000,      -0.100,       0.000>
  direction <        0.0,         0.0,      0.4330> // Aperture is 1.71 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.000,       0.000,       0.000>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Pit_Light
  <73.577, 245.923, -269.588>
  color rgb <1.000, 0.000, 0.000>*0.0000
}

light_source {   // Spotlight Sig_Spot
  <61.857, 345.953, 34.257>
  color rgb <1.000, 1.000, 1.000>*0.8500
  spotlight
    point_at  <65.824, 336.776, 34.485>
    falloff    18.333  // outer radius (in deg)
    radius     12.635  // inner radius
    tightness  22.220
}

light_source {   // Spotlight Lens_Flare
  <77.912, 339.458, 57.164>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <75.927, 339.458, 56.926>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
}

light_source {   // Spotlight Pend_Spot
  <59.214, 318.506, 89.676>
  color rgb <1.000, 1.000, 1.000>*0.0000
  spotlight
    point_at  <79.130, 317.883, 58.610>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
}

light_source {   // Spotlight Masque_Figure_Spot
  <70.610, 310.655, 44.664>
  color rgb <1.000, 1.000, 1.000>*0.9999
  spotlight
    point_at  <63.329, 310.655, 51.519>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
}

light_source {   // Spotlight Wall_Spot
  <140.960, 291.898, 7.662>
  color rgb <1.000, 1.000, 1.000>*0.2800
  spotlight
    point_at  <155.103, 298.433, 25.918>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
}

light_source {   // Spotlight Coffin_Cover_Spot
  <81.086, 342.310, 122.554>
  color rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <94.095, 343.762, 43.632>
    falloff    22.894  // outer radius (in deg)
    radius     11.497  // inner radius
    tightness  0.000
  fade_distance  12.0
  fade_power 1.0
}

light_source {   // Spotlight raven_Spot
  <-22.355, 314.498, 40.476>
  color rgb <1.000, 1.000, 1.000>*0.7500
  spotlight
    point_at  <18.732, 322.636, 51.568>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
}

light_source {   // Spotlight Bottle_Spot
  <66.607, 338.016, 55.231>
  color rgb <1.000, 1.000, 1.000>*0.7500
  spotlight
    point_at  <74.379, 350.529, 41.704>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
}

light_source {   // Spotlight Face_Spot
  <161.906, 313.870, 91.446>
  color rgb <1.000, 1.000, 1.000>*0.7139
  spotlight
    point_at  <167.851, 313.867, 92.257>
    falloff    45.688  // outer radius (in deg)
    radius     45.688  // inner radius
    tightness  0.000
  shadowless
}

light_source {   // Spotlight Bottle_Spot1
  <64.183, 320.200, 55.231>
  color rgb <1.000, 1.000, 1.000>*0.7500
  spotlight
    point_at  <71.956, 332.714, 41.704>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
}

light_source {   // Spotlight Masque_Figure_Spot1
  <76.737, 310.222, 60.188>
  color rgb <1.000, 0.000, 0.000>*6.9993
  spotlight
    point_at  <59.904, 306.105, 70.172>
    falloff    39.989  // outer radius (in deg)
    radius     33.150  // inner radius
    tightness  1.387
}

light_source {   // Sig_Cube_Light
  <50.392, 329.696, 32.354>
  color rgb <1.000, 1.000, 1.000>*0.2500
}

light_source {   // Spotlight Pit_Spot
  <86.503, 257.577, -248.338>
  color rgb <1.000, 0.000, 0.000>*3.7136
  spotlight
    point_at  <86.503, 257.577, 351.662>
    falloff    49.108  // outer radius (in deg)
    radius     49.108  // inner radius
    tightness  0.000
}


//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//
// ********  MATERIALS  *******
//

#include "mep irtc horror 28.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//





#declare sky_vect = <-0.06028, -0.41723, 0.90680>;
#declare cam_loc = <45.350, 336.332, 48.580>;  // using camera 'StdCam'
#declare lookat = <190.506, 317.730, 37.969>;
#declare light_loc = <77.91236, 339.45810, 57.16361>;  // using light source 'Lens Flare'

#declare flare_size = 0.500;
#declare bright_background = 0;
#declare flare_brightness = 1.000;
// Note: if the following two lines cause an error, make sure that
// you have the NKFlare\ subdirectory in the directory where you are
// exporting POV-files to.
#include "NKFlare\Space3.flr"
#include "NKFlare\nkflare.inc"
















#declare Raven_Hgtfld = object { 
  height_field {
    tga "C:\Program Files\Moray For Windows\Mdl\raven neg fig.tga"
    water_level 0.2857
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <11.057378, 11.057378, 1.0>
}
#declare Raven_Cut_Eye = difference {
  object { Raven_Hgtfld }
  material {
    PDB_Tex_C
  }
}
union { // Raven_Sil
  object { Raven_Cut_Eye }
  cylinder { // Raven_Eye_Ruby
    <0,0,1>, <0,0,0>, 1 
    material {
      Ruby_Glass
    }
    scale <0.321, 0.321, 0.1>
    translate  <6.012346, 9.781648, 0.0>
  }
  rotate <-90.0, -180.0, -74.510902>
  translate  <34.921418, 325.331987, 49.300427>
}


#declare PND_B_Shaft = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1100, 0.1100, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.0100, 0.0100, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.1100, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.2120, -0.2120, 0.7980>, <0.2120, 0.2120, 1.0020> } } }
  torus { 0.1100, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.1120, -0.1120, -0.0020>, <0.1120, 0.1120, 0.1020> } } }
  scale <240.0, 240.0, 3.0>
  rotate -90.0*y
}
#declare PND_Blur = merge {
  object { PND_B_Shaft }
  torus { // PND_B_Weight
    229.9, 8.0  rotate -x*90
    rotate -90.0*y
  }
  torus { // PND_B_Blade
    240.0, 40.0  rotate -x*90
    sturm
    scale <1.0, 1.0, 0.02>
    rotate -90.0*y
  }
  no_shadow
}
#declare Pend_Blur = difference {
  object { PND_Blur }
  box { // PND_Blur_Cut
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 140.0, 280.0>
    translate  140.0*y
  }
  box { // PND_Blur_Cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 140.0, 280.0>
    rotate 90.0*x
    translate  140.0*z
  }
  material {
    Bronze_Metal_5_1
  }
}
#declare PND_Blade_and_Edge = union {
  sphere { // PND_Blade
    <0,0,0>,1
    scale <1.5, 36.0, 36.0>
  }
  sphere { // PND_Edge
    <0,0,0>,1
    material {
      B_Silver
    }
    scale <0.75, 38.0, 40.0>
  }
}
#declare PND_Blade_and_Cuts = difference {
  object { PND_Blade_and_Edge }
  cylinder { // PND_BLD_Cutout
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 18.0, 4.0>
    rotate -90.0*y
    translate  <2.0, 20.0, 8.5>
  }
  cylinder { // PND_BLD_Cutout1
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 18.0, 4.0>
    rotate -90.0*y
    translate  <2.0, -20.0, 8.5>
  }
}
#declare PND_Blade_Asmbly = union {
  object { PND_Blade_and_Cuts }
  sphere { // PND_Weight
    <0,0,0>,1
    scale 8.0
    translate  10.0*z
  }
  torus { // Torus001
    3.5, 2.5  rotate -x*90
  }
  cone { // Cone001
    <0,0,0>, 4.0, <0,0,1>, 0.5
    scale <1.0, 1.0, 35.0>
    rotate <0.0, -180.0, -180.0>
  }
  torus { // Torus002
    3.5, 2.5  rotate -x*90
    translate  18.0*z
  }
  translate  -240.0*z
}
#declare Pendulum = union {
  cylinder { // PND_Shaft
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 240.0>
    translate  -240.0*z
  }
  object { PND_Blade_Asmbly }
  material {
    Bronze_Metal
  }
}
union { // Pend_and_Blur
  object { Pend_Blur }
  object { Pendulum }
  no_shadow
  scale 0.5
  rotate <0.0, 30.156281, 21.391941>
  translate  <135.238208, 343.487644, 158.591862>
}


#declare Shelf6 = merge {
  sphere { <47.0000, 25.0000, 2.0000>, 1.0000 }
  sphere { <47.0000, -25.0000, 2.0000>, 1.0000 }
  sphere { <-47.0000, -25.0000, 2.0000>, 1.0000 }
  sphere { <-47.0000, 25.0000, 2.0000>, 1.0000 }
  sphere { <47.0000, 25.0000, -2.0000>, 1.0000 }
  sphere { <47.0000, -25.0000, -2.0000>, 1.0000 }
  sphere { <-47.0000, -25.0000, -2.0000>, 1.0000 }
  sphere { <-47.0000, 25.0000, -2.0000>, 1.0000 }
  cylinder { <47.0000, 25.0000, 2.0000>, <-47.0000, 25.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, -25.0000, 2.0000>, <-47.0000, -25.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, -25.0000, -2.0000>, <-47.0000, -25.0000, -2.0000>, 1.0000 }
  cylinder { <47.0000, 25.0000, -2.0000>, <-47.0000, 25.0000, -2.0000>, 1.0000 }
  cylinder { <47.0000, 25.0000, -2.0000>, <47.0000, 25.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, -25.0000, -2.0000>, <47.0000, -25.0000, 2.0000>, 1.0000 }
  cylinder { <-47.0000, -25.0000, -2.0000>, <-47.0000, -25.0000, 2.0000>, 1.0000 }
  cylinder { <-47.0000, 25.0000, -2.0000>, <-47.0000, 25.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, 25.0000, 2.0000>, <47.0000, -25.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, 25.0000, -2.0000>, <47.0000, -25.0000, -2.0000>, 1.0000 }
  cylinder { <-47.0000, 25.0000, -2.0000>, <-47.0000, -25.0000, -2.0000>, 1.0000 }
  cylinder { <-47.0000, 25.0000, 2.0000>, <-47.0000, -25.0000, 2.0000>, 1.0000 }
  box { <-47.0000, -25.0000, -3.0000> <47.0000, 25.0000, 3.0000> }
  box { <-47.0000, -26.0000, -2.0000> <47.0000, 26.0000, 2.0000> }
  box { <-48.0000, -25.0000, -2.0000> <48.0000, 25.0000, 2.0000> }
// Attributes returned success!
  translate  <42.0, 141.330986, 36.0>
}
#declare Arches = union {
  torus { // Arch_1
    24.0, 6.0  rotate -x*90
    rotate <0.0, -90.0, 0.0>
  }
  torus { // Arch_2
    24.0, 3.0  rotate -x*90
    rotate -90.0*y
    translate  -5.0*x
  }
  torus { // Arch_3
    22.0, 0.5  rotate -x*90
    rotate -90.0*y
    translate  -8.0*x
  }
}
#declare Arch_Top = difference {
  object { Arches }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 32.0, 16.0>
    translate  -16.0*z
  }
}
#declare Arch_Rounds = union {
  object { Arch_Top }
  cylinder { // A_Col_1
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 72.010002>
    translate  <0.0, 24.0, -72.0>
  }
  cylinder { // A_Col_2
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 72.010002>
    translate  <0.0, -24.0, -72.0>
  }
  cylinder { // A_Small
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 72.010002>
    translate  <-8.0, 22.0, -72.0>
  }
  cylinder { // A_Small1
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 72.010002>
    translate  <-8.0, -22.0, -72.0>
  }
  cylinder { // A_Col_3
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 72.010002>
    translate  <-5.0, 24.0, -72.0>
  }
  cylinder { // A_Col_4
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 72.010002>
    translate  <-5.0, -24.0, -72.0>
  }
  scale <0.5, 1.0, 1.0>
  translate  <-0.454043, 183.200417, 72.0>
}
#declare Arches1 = union {
  torus { // Arch_4
    24.0, 6.0  rotate -x*90
    rotate <0.0, -90.0, 0.0>
  }
  torus { // Arch_5
    24.0, 3.0  rotate -x*90
    rotate -90.0*y
    translate  -5.0*x
  }
  torus { // Arch_6
    22.0, 0.5  rotate -x*90
    rotate -90.0*y
    translate  -8.0*x
  }
}
#declare Arch_Top1 = difference {
  object { Arches1 }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 32.0, 16.0>
    translate  -16.0*z
  }
}
#declare Arch_Rounds1 = union {
  object { Arch_Top1 }
  cylinder { // A_Col_5
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 72.010002>
    translate  <0.0, 24.0, -72.0>
  }
  cylinder { // A_Col_6
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 72.010002>
    translate  <0.0, -24.0, -72.0>
  }
  cylinder { // A_Small2
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 72.010002>
    translate  <-8.0, 22.0, -72.0>
  }
  cylinder { // A_Small3
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 72.010002>
    translate  <-8.0, -22.0, -72.0>
  }
  cylinder { // A_Col_7
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 72.010002>
    translate  <-5.0, 24.0, -72.0>
  }
  cylinder { // A_Col_8
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 72.010002>
    translate  <-5.0, -24.0, -72.0>
  }
  scale <0.5, 1.0, 1.0>
  translate  <-0.454043, 100.0, 72.0>
}
#declare Shelf7 = merge {
  sphere { <47.0000, 25.0000, 2.0000>, 1.0000 }
  sphere { <47.0000, -25.0000, 2.0000>, 1.0000 }
  sphere { <-47.0000, -25.0000, 2.0000>, 1.0000 }
  sphere { <-47.0000, 25.0000, 2.0000>, 1.0000 }
  sphere { <47.0000, 25.0000, -2.0000>, 1.0000 }
  sphere { <47.0000, -25.0000, -2.0000>, 1.0000 }
  sphere { <-47.0000, -25.0000, -2.0000>, 1.0000 }
  sphere { <-47.0000, 25.0000, -2.0000>, 1.0000 }
  cylinder { <47.0000, 25.0000, 2.0000>, <-47.0000, 25.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, -25.0000, 2.0000>, <-47.0000, -25.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, -25.0000, -2.0000>, <-47.0000, -25.0000, -2.0000>, 1.0000 }
  cylinder { <47.0000, 25.0000, -2.0000>, <-47.0000, 25.0000, -2.0000>, 1.0000 }
  cylinder { <47.0000, 25.0000, -2.0000>, <47.0000, 25.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, -25.0000, -2.0000>, <47.0000, -25.0000, 2.0000>, 1.0000 }
  cylinder { <-47.0000, -25.0000, -2.0000>, <-47.0000, -25.0000, 2.0000>, 1.0000 }
  cylinder { <-47.0000, 25.0000, -2.0000>, <-47.0000, 25.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, 25.0000, 2.0000>, <47.0000, -25.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, 25.0000, -2.0000>, <47.0000, -25.0000, -2.0000>, 1.0000 }
  cylinder { <-47.0000, 25.0000, -2.0000>, <-47.0000, -25.0000, -2.0000>, 1.0000 }
  cylinder { <-47.0000, 25.0000, 2.0000>, <-47.0000, -25.0000, 2.0000>, 1.0000 }
  box { <-47.0000, -25.0000, -3.0000> <47.0000, 25.0000, 3.0000> }
  box { <-47.0000, -26.0000, -2.0000> <47.0000, 26.0000, 2.0000> }
  box { <-48.0000, -25.0000, -2.0000> <48.0000, 25.0000, 2.0000> }
// Attributes returned success!
  translate  <42.255399, 225.169014, 36.0>
}
#declare Arches2 = union {
  torus { // Arch_7
    24.0, 6.0  rotate -x*90
    rotate <0.0, -90.0, 0.0>
  }
  torus { // Arch_8
    24.0, 3.0  rotate -x*90
    rotate -90.0*y
    translate  -5.0*x
  }
  torus { // Arch_9
    22.0, 0.5  rotate -x*90
    rotate -90.0*y
    translate  -8.0*x
  }
}
#declare Arch_Top2 = difference {
  object { Arches2 }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 32.0, 16.0>
    translate  -16.0*z
  }
}
#declare Arch_Rounds2 = union {
  object { Arch_Top2 }
  cylinder { // A_Col_9
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 72.010002>
    translate  <0.0, 24.0, -72.0>
  }
  cylinder { // A_Col_10
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 72.010002>
    translate  <0.0, -24.0, -72.0>
  }
  cylinder { // A_Small4
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 72.010002>
    translate  <-8.0, 22.0, -72.0>
  }
  cylinder { // A_Small5
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 72.010002>
    translate  <-8.0, -22.0, -72.0>
  }
  cylinder { // A_Col_11
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 72.010002>
    translate  <-5.0, 24.0, -72.0>
  }
  cylinder { // A_Col_12
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 72.010002>
    translate  <-5.0, -24.0, -72.0>
  }
  scale <0.5, 1.0, 1.0>
  translate  <-0.454043, 268.0, 72.0>
}
#declare Shelf8 = merge {
  sphere { <47.0000, 29.0000, 2.0000>, 1.0000 }
  sphere { <47.0000, -29.0000, 2.0000>, 1.0000 }
  sphere { <-47.0000, -29.0000, 2.0000>, 1.0000 }
  sphere { <-47.0000, 29.0000, 2.0000>, 1.0000 }
  sphere { <47.0000, 29.0000, -2.0000>, 1.0000 }
  sphere { <47.0000, -29.0000, -2.0000>, 1.0000 }
  sphere { <-47.0000, -29.0000, -2.0000>, 1.0000 }
  sphere { <-47.0000, 29.0000, -2.0000>, 1.0000 }
  cylinder { <47.0000, 29.0000, 2.0000>, <-47.0000, 29.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, -29.0000, 2.0000>, <-47.0000, -29.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, -29.0000, -2.0000>, <-47.0000, -29.0000, -2.0000>, 1.0000 }
  cylinder { <47.0000, 29.0000, -2.0000>, <-47.0000, 29.0000, -2.0000>, 1.0000 }
  cylinder { <47.0000, 29.0000, -2.0000>, <47.0000, 29.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, -29.0000, -2.0000>, <47.0000, -29.0000, 2.0000>, 1.0000 }
  cylinder { <-47.0000, -29.0000, -2.0000>, <-47.0000, -29.0000, 2.0000>, 1.0000 }
  cylinder { <-47.0000, 29.0000, -2.0000>, <-47.0000, 29.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, 29.0000, 2.0000>, <47.0000, -29.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, 29.0000, -2.0000>, <47.0000, -29.0000, -2.0000>, 1.0000 }
  cylinder { <-47.0000, 29.0000, -2.0000>, <-47.0000, -29.0000, -2.0000>, 1.0000 }
  cylinder { <-47.0000, 29.0000, 2.0000>, <-47.0000, -29.0000, 2.0000>, 1.0000 }
  box { <-47.0000, -29.0000, -3.0000> <47.0000, 29.0000, 3.0000> }
  box { <-47.0000, -30.0000, -2.0000> <47.0000, 30.0000, 2.0000> }
  box { <-48.0000, -29.0000, -2.0000> <48.0000, 29.0000, 2.0000> }
// Attributes returned success!
  translate  <42.0, 55.0, 36.0>
}
#declare Shelf9 = merge {
  sphere { <47.0000, 29.0000, 2.0000>, 1.0000 }
  sphere { <47.0000, -29.0000, 2.0000>, 1.0000 }
  sphere { <-47.0000, -29.0000, 2.0000>, 1.0000 }
  sphere { <-47.0000, 29.0000, 2.0000>, 1.0000 }
  sphere { <47.0000, 29.0000, -2.0000>, 1.0000 }
  sphere { <47.0000, -29.0000, -2.0000>, 1.0000 }
  sphere { <-47.0000, -29.0000, -2.0000>, 1.0000 }
  sphere { <-47.0000, 29.0000, -2.0000>, 1.0000 }
  cylinder { <47.0000, 29.0000, 2.0000>, <-47.0000, 29.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, -29.0000, 2.0000>, <-47.0000, -29.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, -29.0000, -2.0000>, <-47.0000, -29.0000, -2.0000>, 1.0000 }
  cylinder { <47.0000, 29.0000, -2.0000>, <-47.0000, 29.0000, -2.0000>, 1.0000 }
  cylinder { <47.0000, 29.0000, -2.0000>, <47.0000, 29.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, -29.0000, -2.0000>, <47.0000, -29.0000, 2.0000>, 1.0000 }
  cylinder { <-47.0000, -29.0000, -2.0000>, <-47.0000, -29.0000, 2.0000>, 1.0000 }
  cylinder { <-47.0000, 29.0000, -2.0000>, <-47.0000, 29.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, 29.0000, 2.0000>, <47.0000, -29.0000, 2.0000>, 1.0000 }
  cylinder { <47.0000, 29.0000, -2.0000>, <47.0000, -29.0000, -2.0000>, 1.0000 }
  cylinder { <-47.0000, 29.0000, -2.0000>, <-47.0000, -29.0000, -2.0000>, 1.0000 }
  cylinder { <-47.0000, 29.0000, 2.0000>, <-47.0000, -29.0000, 2.0000>, 1.0000 }
  box { <-47.0000, -29.0000, -3.0000> <47.0000, 29.0000, 3.0000> }
  box { <-47.0000, -30.0000, -2.0000> <47.0000, 30.0000, 2.0000> }
  box { <-48.0000, -29.0000, -2.0000> <48.0000, 29.0000, 2.0000> }
// Attributes returned success!
  translate  <42.0, 312.72603, 36.0>
}
#declare Arches_and_shelves = union {
  object { Shelf6 }
  object { Arch_Rounds }
  object { Arch_Rounds1 }
  object { Shelf7 }
  object { Arch_Rounds2 }
  object { Shelf8 }
  object { Shelf9 }
  box { // Big_Block1
    <-1, -1, -1>, <1, 1, 1>
    material {
      MEP_Stone
    }
    scale <60.0, 30.0, 55.0>
    rotate <-0.0, -0.0, -0.0>
    translate  <92.521353, 99.115076, 49.83071>
  }
  box { // Big_Block2
    <-1, -1, -1>, <1, 1, 1>
    material {
      MEP_Stone
    }
    scale <60.0, 30.0, 55.0>
    rotate <-0.0, -0.0, -0.0>
    translate  <91.751388, 269.856151, 49.918775>
  }
  box { // Big_Block3
    <-1, -1, -1>, <1, 1, 1>
    material {
      Transparent_Gauze
    }
    hollow
    scale <60.0, 30.0, 55.0>
    rotate <-0.0, -0.0, -0.0>
    translate  <60.953496, 269.856151, 49.491399>
  }
  box { // Big_Block4
    <-1, -1, -1>, <1, 1, 1>
    material {
      Transparent_Gauze
    }
    scale <60.0, 30.0, 55.0>
    rotate <-0.0, -0.0, -0.0>
    translate  <60.110632, 99.115076, 49.587802>
  }
  material {
    Pink_Granit
  }
}
#declare Granite_Course6 = union {
  box { // Granite_Block48
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  255.5*y
  }
  box { // Granite_Block49
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  219.0*y
  }
  box { // Granite_Block50
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  182.5*y
  }
  box { // Granite_Block51
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -0.0*y
    translate  146.0*y
  }
  box { // Granite_Block52
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  109.5*y
  }
  box { // Granite_Block53
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  73.0*y
  }
  box { // Granite_Block54
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  36.5*y
  }
  box { // Granite_Block55
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
  }
  rotate <180.0, 0.0, 180.0>
  translate  147.0*z
}
#declare Granite_Course5 = union {
  box { // Granite_Block40
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  255.5*y
  }
  box { // Granite_Block41
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  219.0*y
  }
  box { // Granite_Block42
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  182.5*y
  }
  box { // Granite_Block43
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -0.0*y
    translate  146.0*y
  }
  box { // Granite_Block44
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  109.5*y
  }
  box { // Granite_Block45
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  73.0*y
  }
  box { // Granite_Block46
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  36.5*y
  }
  box { // Granite_Block47
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
  }
  rotate -90.0*y
  translate  <0.0, 18.25, 122.5>
}
#declare Granite_Course4 = union {
  box { // Granite_Block32
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  255.5*y
  }
  box { // Granite_Block33
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  219.0*y
  }
  box { // Granite_Block34
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  182.5*y
  }
  box { // Granite_Block35
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -0.0*y
    translate  146.0*y
  }
  box { // Granite_Block36
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  109.5*y
  }
  box { // Granite_Block37
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  73.0*y
  }
  box { // Granite_Block38
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  36.5*y
  }
  box { // Granite_Block39
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
  }
  rotate -0.0*y
  translate  98.0*z
}
#declare Granite_Course3 = union {
  box { // Granite_Block24
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  255.5*y
  }
  box { // Granite_Block25
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  219.0*y
  }
  box { // Granite_Block26
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  182.5*y
  }
  box { // Granite_Block27
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -0.0*y
    translate  146.0*y
  }
  box { // Granite_Block28
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  109.5*y
  }
  box { // Granite_Block29
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  73.0*y
  }
  box { // Granite_Block30
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  36.5*y
  }
  box { // Granite_Block31
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
  }
  rotate 90.0*y
  translate  <0.0, 18.25, 73.5>
}
#declare Granite_Course2 = union {
  box { // Granite_Block16
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  255.5*y
  }
  box { // Granite_Block17
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  219.0*y
  }
  box { // Granite_Block18
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  182.5*y
  }
  box { // Granite_Block19
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -0.0*y
    translate  146.0*y
  }
  box { // Granite_Block20
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  109.5*y
  }
  box { // Granite_Block21
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  73.0*y
  }
  box { // Granite_Block22
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  36.5*y
  }
  box { // Granite_Block23
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
  }
  rotate <180.0, 0.0, 180.0>
  translate  49.0*z
}
#declare Granite_Course1 = union {
  box { // Granite_Block8
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  255.5*y
  }
  box { // Granite_Block9
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  219.0*y
  }
  box { // Granite_Block10
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  182.5*y
  }
  box { // Granite_Block11
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -0.0*y
    translate  146.0*y
  }
  box { // Granite_Block12
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  109.5*y
  }
  box { // Granite_Block13
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  73.0*y
  }
  box { // Granite_Block14
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  36.5*y
  }
  box { // Granite_Block15
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
  }
  rotate -90.0*y
  translate  <0.0, 18.25, 24.5>
}
#declare Granite_Course = union {
  box { // Granite_Block7
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  255.5*y
  }
  box { // Granite_Block6
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  219.0*y
  }
  box { // Granite_Block5
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  182.5*y
  }
  box { // Granite_Block4
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -0.0*y
    translate  146.0*y
  }
  box { // Granite_Block3
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  109.5*y
  }
  box { // Granite_Block2
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  73.0*y
  }
  box { // Granite_Block1
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  36.5*y
  }
  box { // Granite_Block56
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
  }
}
#declare Granite_Wall = union {
  object { Granite_Course6 }
  object { Granite_Course5 }
  object { Granite_Course4 }
  object { Granite_Course3 }
  object { Granite_Course2 }
  object { Granite_Course1 }
  object { Granite_Course }
  box { // Big_Block
    <-1, -1, -1>, <1, 1, 1>
    material {
      Gray_Vein_Granit
    }
    scale <99.5, 200.0, 100.0>
    rotate <-0.0, -0.0, -0.0>
    translate  <88.0, 150.0, 88.0>
  }
  translate  <12.0, 50.0, 12.0>
}
#declare Alcove_Niche6 = union {
  box { // Alcove_Open_cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <48.0, 18.0, 36.0>
    translate  36.0*z
  }
  cylinder { // Alcove_Open_Arch8
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 18.0, 96.0>
    rotate -90.0*y
    translate  <48.0, 0.0, 72.0>
  }
}
#declare Alcove_Niche7 = union {
  box { // Alcove_Open_cube9
    <-1, -1, -1>, <1, 1, 1>
    scale <48.0, 24.0, 36.0>
    translate  36.0*z
  }
  cylinder { // Alcove_Open_Arch9
    <0,0,1>, <0,0,0>, 1 
    scale <24.0, 24.0, 96.0>
    rotate -90.0*y
    translate  <48.0, 0.0, 72.0>
  }
  translate  84.0*y
}
#declare Alcove_Niche8 = union {
  box { // Alcove_Open_cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <48.0, 18.0, 36.0>
    translate  36.0*z
  }
  cylinder { // Alcove_Open_Arch10
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 18.0, 96.0>
    rotate -90.0*y
    translate  <48.0, 0.0, 72.0>
  }
  translate  168.0*y
}
#declare Alcoves1 = union {
  object { Alcove_Niche6 }
  object { Alcove_Niche7 }
  object { Alcove_Niche8 }
  translate  <39.019301, 99.321857, 0.0>
}
#declare Walls_and_Niches = difference {
  object { Granite_Wall }
  object { Alcoves1 }
  material {
    RoughStone_1
  }
}
#declare Base_Stone155 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone155 = difference {
  object { Base_Stone155 }
  box { // STN_cut_931
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_932
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_933
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_934
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_935
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_936
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone156 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone156 = difference {
  object { Base_Stone156 }
  box { // STN_cut_937
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_938
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_939
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_940
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_941
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_942
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone157 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone157 = difference {
  object { Base_Stone157 }
  box { // STN_cut_943
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_944
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_945
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_946
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_947
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_948
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone158 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone158 = difference {
  object { Base_Stone158 }
  box { // STN_cut_949
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_950
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_951
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_952
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone159 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone159 = difference {
  object { Base_Stone159 }
  box { // STN_cut_953
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_954
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_955
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_956
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_957
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_958
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare W_Course22 = union {
  object { Stone155 }
  object { Stone156 }
  object { Stone157 }
  object { Stone158 }
  object { Stone159 }
  material {
    RoughStone
  }
  rotate -90.0*y
  translate  75.907746*z
}
#declare Base_Stone170 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone170 = difference {
  object { Base_Stone170 }
  box { // STN_cut_1019
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1020
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1021
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1022
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1023
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1024
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone171 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone171 = difference {
  object { Base_Stone171 }
  box { // STN_cut_1025
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1026
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1027
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1028
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1029
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1030
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone172 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone172 = difference {
  object { Base_Stone172 }
  box { // STN_cut_1031
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1032
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1033
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1034
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1035
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1036
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare W_Course24 = union {
  object { Stone170 }
  object { Stone171 }
  object { Stone172 }
  rotate 90.0*y
  translate  <0.0, 4.5, 90.25>
}
#declare Base_Stone176 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone176 = difference {
  object { Base_Stone176 }
  box { // STN_cut_1055
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1056
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1057
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1058
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1059
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1060
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone177 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone177 = difference {
  object { Base_Stone177 }
  box { // STN_cut_1061
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1062
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1063
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1064
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1065
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1066
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone178 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone178 = difference {
  object { Base_Stone178 }
  box { // STN_cut_1067
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1068
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1069
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1070
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1071
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1072
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone179 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone179 = difference {
  object { Base_Stone179 }
  box { // STN_cut_1073
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1074
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1075
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1076
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1077
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1078
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare W_Course25 = union {
  object { Stone176 }
  object { Stone177 }
  object { Stone178 }
  object { Stone179 }
  rotate <180.0, 0.0, 180.0>
  translate  85.5*z
}
#declare Base_Stone183 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone183 = difference {
  object { Base_Stone183 }
  box { // STN_cut_1097
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1098
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1099
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1100
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1101
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1102
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone184 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone184 = difference {
  object { Base_Stone184 }
  box { // STN_cut_1103
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1104
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1105
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1106
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1107
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1108
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone185 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone185 = difference {
  object { Base_Stone185 }
  box { // STN_cut_1109
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1110
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1111
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1112
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1113
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1114
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone186 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone186 = difference {
  object { Base_Stone186 }
  box { // STN_cut_1115
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1116
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1117
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1118
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1119
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1120
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone187 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone187 = difference {
  object { Base_Stone187 }
  box { // STN_cut_1121
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1122
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1123
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1124
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1125
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1126
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare W_Course26 = union {
  object { Stone183 }
  object { Stone184 }
  object { Stone185 }
  object { Stone186 }
  object { Stone187 }
  rotate -90.0*y
  translate  <0.0, 4.5, 80.75>
}
#declare Base_Stone109 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone109 = difference {
  object { Base_Stone109 }
  box { // STN_cut_655
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_656
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_657
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_658
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_659
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_660
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone115 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone115 = difference {
  object { Base_Stone115 }
  box { // STN_cut_673
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_674
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_675
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <1.745598, -0.930338, 30.821426>
    translate  <0.762713, 1.845048, -2.165449>
  }
  box { // STN_cut_679
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_681
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_682
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone189 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone189 = difference {
  object { Base_Stone189 }
  box { // STN_cut_683
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_691
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_692
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_693
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_694
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_695
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare W_Course27 = union {
  object { Stone109 }
  object { Stone115 }
  object { Stone189 }
  rotate 90.0*y
  translate  <0.0, 4.5, 71.25>
}
#declare Base_Stone101 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone101 = difference {
  object { Base_Stone101 }
  box { // STN_cut_607
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_608
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  rotate <178.654663, -3.410339, -178.069092>
  translate  54.0*y
}
#declare Base_Stone191 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone191 = difference {
  object { Base_Stone191 }
  box { // STN_cut_713
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  sphere { // STN_cut_1133
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1134
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone192 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone192 = difference {
  object { Base_Stone192 }
  box { // STN_cut_1137
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1138
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1139
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1140
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1141
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1142
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone193 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone193 = difference {
  object { Base_Stone193 }
  cylinder { // STN_cut_1144
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1148
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone194 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone194 = difference {
  object { Base_Stone194 }
  sphere { // STN_cut_1151
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1152
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare W_Course28 = union {
  object { Stone101 }
  object { Stone191 }
  object { Stone192 }
  object { Stone193 }
  object { Stone194 }
  rotate <180.0, 0.0, 180.0>
  translate  66.5*z
}
#declare Base_Stone197 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone197 = difference {
  object { Base_Stone197 }
  box { // STN_cut_1167
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1168
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1169
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1170
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1171
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1172
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone198 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone198 = difference {
  object { Base_Stone198 }
  box { // STN_cut_1173
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1174
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1175
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1176
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1177
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1178
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.89634, 1.969626, 2.16853>
  }
  rotate <-0.402281, 3.379527, 1.818361>
  translate  <0.002602, 36.0, 0.022747>
}
#declare Base_Stone199 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone199 = difference {
  object { Base_Stone199 }
  box { // STN_cut_1179
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1180
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1181
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1182
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1183
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1184
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone200 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone200 = difference {
  object { Base_Stone200 }
  box { // STN_cut_1185
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1186
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1187
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1188
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1189
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1190
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone201 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone201 = difference {
  object { Base_Stone201 }
  box { // STN_cut_1191
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1192
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1193
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1194
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1195
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1196
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare W_Course29 = union {
  object { Stone197 }
  object { Stone198 }
  object { Stone199 }
  object { Stone200 }
  object { Stone201 }
  rotate -90.0*y
  translate  <0.0, 4.5, 61.75>
}
#declare Base_Stone204 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone204 = difference {
  object { Base_Stone204 }
  cylinder { // STN_cut_1210
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1214
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone205 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone205 = difference {
  object { Base_Stone205 }
  box { // STN_cut_1215
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1216
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <122.453773, -192.017105, 182.96907>
    translate  <-2.317714, 2.243113, 0.695567>
  }
  rotate <-1.006486, 3.393272, 3.846184>
  translate  36.0*y
}
#declare Base_Stone206 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone206 = difference {
  object { Base_Stone206 }
  sphere { // STN_cut_1223
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1224
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone207 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone207 = difference {
  object { Base_Stone207 }
  box { // STN_cut_1230
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1231
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1232
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone208 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone208 = difference {
  object { Base_Stone208 }
  cylinder { // STN_cut_1234
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1238
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare W_Course30 = union {
  object { Stone204 }
  object { Stone205 }
  object { Stone206 }
  object { Stone207 }
  object { Stone208 }
  rotate <-0.0, -0.0, -0.0>
  translate  57.0*z
}
#declare Base_Stone211 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone211 = difference {
  object { Base_Stone211 }
  box { // STN_cut_1251
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1252
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1253
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1254
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1255
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1256
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone212 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone212 = difference {
  object { Base_Stone212 }
  box { // STN_cut_1257
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1258
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1259
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1260
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1261
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1262
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone213 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone213 = difference {
  object { Base_Stone213 }
  box { // STN_cut_1263
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1264
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1265
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1266
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1267
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1268
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone214 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone214 = difference {
  object { Base_Stone214 }
  box { // STN_cut_1269
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1270
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1271
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1272
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1273
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1274
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone215 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone215 = difference {
  object { Base_Stone215 }
  box { // STN_cut_1275
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1276
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1277
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1278
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1279
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1280
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare Base_Stone216 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone216 = difference {
  object { Base_Stone216 }
  box { // STN_cut_1281
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1282
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1283
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1284
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1285
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1286
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345342, 3.410346, 1.930861>
}
#declare W_Course31 = union {
  object { Stone211 }
  object { Stone212 }
  object { Stone213 }
  object { Stone214 }
  object { Stone215 }
  object { Stone216 }
  rotate 90.0*y
  translate  <0.0, 4.5, 52.25>
}
#declare Base_Stone217 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone217 = difference {
  object { Base_Stone217 }
  box { // STN_cut_1287
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1288
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1289
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1290
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1291
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1292
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <178.654663, -3.410339, -178.069092>
  translate  54.0*y
}
#declare Base_Stone218 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone218 = difference {
  object { Base_Stone218 }
  box { // STN_cut_1293
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1294
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1295
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1296
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1297
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1298
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone219 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone219 = difference {
  object { Base_Stone219 }
  box { // STN_cut_1299
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1300
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1301
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1302
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1303
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1304
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone220 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone220 = difference {
  object { Base_Stone220 }
  box { // STN_cut_1305
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1306
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1307
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1308
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1309
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1310
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone221 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone221 = difference {
  object { Base_Stone221 }
  box { // STN_cut_1311
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1312
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1313
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1314
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1315
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1316
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone222 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone222 = difference {
  object { Base_Stone222 }
  box { // STN_cut_1317
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1318
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1319
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1320
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1321
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1322
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare W_Course32 = union {
  object { Stone217 }
  object { Stone218 }
  object { Stone219 }
  object { Stone220 }
  object { Stone221 }
  object { Stone222 }
  rotate <180.0, 0.0, 180.0>
  translate  47.5*z
}
#declare Base_Stone225 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone225 = difference {
  object { Base_Stone225 }
  box { // STN_cut_1335
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1336
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1337
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1338
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1339
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1340
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone226 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone226 = difference {
  object { Base_Stone226 }
  box { // STN_cut_1341
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1342
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1343
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1344
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1345
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1346
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone227 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone227 = difference {
  object { Base_Stone227 }
  box { // STN_cut_1347
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1348
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1349
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1350
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1351
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1352
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone228 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone228 = difference {
  object { Base_Stone228 }
  box { // STN_cut_1353
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1354
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1355
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1356
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1357
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1358
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone229 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone229 = difference {
  object { Base_Stone229 }
  box { // STN_cut_1359
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1360
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1361
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1362
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1363
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1364
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare Base_Stone230 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone230 = difference {
  object { Base_Stone230 }
  box { // STN_cut_1365
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1366
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1367
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1368
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1369
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1370
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345342, 3.410346, 1.930861>
}
#declare W_Course33 = union {
  object { Stone225 }
  object { Stone226 }
  object { Stone227 }
  object { Stone228 }
  object { Stone229 }
  object { Stone230 }
  rotate -90.0*y
  translate  <0.0, 4.5, 42.75>
}
#declare Base_Stone231 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone231 = difference {
  object { Base_Stone231 }
  box { // STN_cut_1371
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1372
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1373
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1374
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1375
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1376
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <178.654663, -3.410339, -178.069092>
  translate  54.0*y
}
#declare Base_Stone232 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone232 = difference {
  object { Base_Stone232 }
  box { // STN_cut_1377
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1378
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1379
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1380
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1381
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1382
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone233 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone233 = difference {
  object { Base_Stone233 }
  box { // STN_cut_1383
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1384
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1385
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1386
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1387
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1388
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone234 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone234 = difference {
  object { Base_Stone234 }
  box { // STN_cut_1389
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1390
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1391
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1392
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1393
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1394
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone235 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone235 = difference {
  object { Base_Stone235 }
  box { // STN_cut_1395
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1396
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1397
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1398
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1399
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1400
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone236 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone236 = difference {
  object { Base_Stone236 }
  box { // STN_cut_1401
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1402
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1403
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1404
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1405
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1406
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare W_Course34 = union {
  object { Stone231 }
  object { Stone232 }
  object { Stone233 }
  object { Stone234 }
  object { Stone235 }
  object { Stone236 }
  rotate <-0.0, -0.0, -0.0>
  translate  38.0*z
}
#declare Base_Stone239 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone239 = difference {
  object { Base_Stone239 }
  box { // STN_cut_1419
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1420
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1421
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1422
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1423
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1424
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone240 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone240 = difference {
  object { Base_Stone240 }
  box { // STN_cut_1425
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1426
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1427
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1428
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1429
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1430
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone241 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone241 = difference {
  object { Base_Stone241 }
  box { // STN_cut_1431
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1432
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1433
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1434
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1435
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1436
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone242 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone242 = difference {
  object { Base_Stone242 }
  box { // STN_cut_1437
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1438
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1439
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1440
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1441
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1442
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone243 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone243 = difference {
  object { Base_Stone243 }
  box { // STN_cut_1443
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1444
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1445
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1446
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1447
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1448
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare Base_Stone244 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone244 = difference {
  object { Base_Stone244 }
  box { // STN_cut_1449
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1450
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1451
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1452
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1453
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1454
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345342, 3.410346, 1.930861>
}
#declare W_Course35 = union {
  object { Stone239 }
  object { Stone240 }
  object { Stone241 }
  object { Stone242 }
  object { Stone243 }
  object { Stone244 }
  rotate 90.0*y
  translate  <0.0, 4.5, 33.25>
}
#declare Base_Stone246 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone246 = difference {
  object { Base_Stone246 }
  box { // STN_cut_1461
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1462
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1463
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1464
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1465
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1466
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone247 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone247 = difference {
  object { Base_Stone247 }
  box { // STN_cut_1467
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1468
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1469
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1470
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1471
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1472
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone248 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone248 = difference {
  object { Base_Stone248 }
  box { // STN_cut_1473
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1474
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1475
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1476
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1477
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1478
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone249 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone249 = difference {
  object { Base_Stone249 }
  box { // STN_cut_1479
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1480
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1481
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1482
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1483
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1484
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone250 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone250 = difference {
  object { Base_Stone250 }
  box { // STN_cut_1485
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1486
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1487
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1488
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1489
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1490
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare W_Course36 = union {
  object { Stone246 }
  object { Stone247 }
  object { Stone248 }
  object { Stone249 }
  object { Stone250 }
  rotate <180.0, 0.0, 180.0>
  translate  28.5*z
}
#declare Base_Stone253 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone253 = difference {
  object { Base_Stone253 }
  box { // STN_cut_1503
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1504
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1505
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1506
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1507
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1508
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone254 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone254 = difference {
  object { Base_Stone254 }
  box { // STN_cut_1509
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1510
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1511
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1512
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1513
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1514
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone255 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone255 = difference {
  object { Base_Stone255 }
  box { // STN_cut_1515
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1516
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1517
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1518
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1519
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1520
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone256 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone256 = difference {
  object { Base_Stone256 }
  box { // STN_cut_1521
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1522
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1523
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1524
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1525
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1526
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone257 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone257 = difference {
  object { Base_Stone257 }
  box { // STN_cut_1527
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1528
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1529
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1530
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1531
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1532
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare Base_Stone258 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone258 = difference {
  object { Base_Stone258 }
  box { // STN_cut_1533
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1534
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1535
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1536
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1537
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1538
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345342, 3.410346, 1.930861>
}
#declare W_Course37 = union {
  object { Stone253 }
  object { Stone254 }
  object { Stone255 }
  object { Stone256 }
  object { Stone257 }
  object { Stone258 }
  rotate -90.0*y
  translate  <0.0, 4.5, 23.75>
}
#declare Base_Stone260 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone260 = difference {
  object { Base_Stone260 }
  box { // STN_cut_1545
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1546
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1547
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1548
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1549
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1550
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone261 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone261 = difference {
  object { Base_Stone261 }
  box { // STN_cut_1551
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1552
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1553
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1554
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1555
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1556
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone262 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone262 = difference {
  object { Base_Stone262 }
  box { // STN_cut_1557
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1558
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1559
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1560
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1561
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1562
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone263 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone263 = difference {
  object { Base_Stone263 }
  box { // STN_cut_1563
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1564
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1565
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1566
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1567
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1568
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone264 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone264 = difference {
  object { Base_Stone264 }
  box { // STN_cut_1569
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1570
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1571
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1572
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1573
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1574
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare W_Course38 = union {
  object { Stone260 }
  object { Stone261 }
  object { Stone262 }
  object { Stone263 }
  object { Stone264 }
  rotate <-0.0, -0.0, -0.0>
  translate  19.0*z
}
#declare Base_Stone267 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone267 = difference {
  object { Base_Stone267 }
  box { // STN_cut_1587
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1588
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1589
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1590
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1591
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1592
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone268 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone268 = difference {
  object { Base_Stone268 }
  box { // STN_cut_1593
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1594
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1595
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1596
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1597
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1598
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone269 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone269 = difference {
  object { Base_Stone269 }
  box { // STN_cut_1599
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1600
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1601
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1602
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1603
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1604
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone270 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone270 = difference {
  object { Base_Stone270 }
  box { // STN_cut_1605
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1606
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1607
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1608
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1609
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1610
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone271 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone271 = difference {
  object { Base_Stone271 }
  box { // STN_cut_1611
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1612
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1613
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1614
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1615
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1616
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare Base_Stone272 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone272 = difference {
  object { Base_Stone272 }
  box { // STN_cut_1617
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1618
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1619
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1620
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1621
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1622
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345342, 3.410346, 1.930861>
}
#declare W_Course39 = union {
  object { Stone267 }
  object { Stone268 }
  object { Stone269 }
  object { Stone270 }
  object { Stone271 }
  object { Stone272 }
  rotate 90.0*y
  translate  <0.0, 4.5, 14.25>
}
#declare Base_Stone274 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone274 = difference {
  object { Base_Stone274 }
  box { // STN_cut_1629
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1630
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1631
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1632
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1633
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1634
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone275 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone275 = difference {
  object { Base_Stone275 }
  box { // STN_cut_1635
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1636
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1637
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1638
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1639
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1640
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone276 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone276 = difference {
  object { Base_Stone276 }
  box { // STN_cut_1641
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1642
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1643
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1644
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1645
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1646
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone277 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone277 = difference {
  object { Base_Stone277 }
  box { // STN_cut_1647
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1648
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1649
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1650
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1651
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1652
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone278 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone278 = difference {
  object { Base_Stone278 }
  box { // STN_cut_1653
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1654
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1655
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1656
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1657
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1658
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare W_Course40 = union {
  object { Stone274 }
  object { Stone275 }
  object { Stone276 }
  object { Stone277 }
  object { Stone278 }
  rotate <180.0, 0.0, 180.0>
  translate  9.5*z
}
#declare Base_Stone281 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone281 = difference {
  object { Base_Stone281 }
  box { // STN_cut_1671
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1672
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1673
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1674
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1675
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1676
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone282 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone282 = difference {
  object { Base_Stone282 }
  box { // STN_cut_1677
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1678
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1679
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1680
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1681
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1682
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone283 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone283 = difference {
  object { Base_Stone283 }
  box { // STN_cut_1683
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1684
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1685
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1686
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1687
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1688
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone284 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone284 = difference {
  object { Base_Stone284 }
  box { // STN_cut_1689
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1690
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1691
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1692
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1693
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1694
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone285 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone285 = difference {
  object { Base_Stone285 }
  box { // STN_cut_1695
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1696
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1697
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1698
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1699
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1700
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare Base_Stone286 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone286 = difference {
  object { Base_Stone286 }
  box { // STN_cut_1701
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1702
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1703
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1704
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1705
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1706
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <-1.345342, 3.410346, 1.930861>
}
#declare W_Course41 = union {
  object { Stone281 }
  object { Stone282 }
  object { Stone283 }
  object { Stone284 }
  object { Stone285 }
  object { Stone286 }
  rotate -90.0*y
  translate  <0.0, 4.5, 4.75>
}
#declare Base_Stone288 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone288 = difference {
  object { Base_Stone288 }
  cylinder { // STN_cut_1714
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1718
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <175.412827, -95.414375, -176.24057>
  translate  45.0*y
}
#declare Base_Stone289 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone289 = difference {
  object { Base_Stone289 }
  box { // STN_cut_1719
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1720
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  rotate <-1.345337, 3.410339, 1.930847>
  translate  36.0*y
}
#declare Base_Stone290 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone290 = difference {
  object { Base_Stone290 }
  box { // STN_cut_1725
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  sphere { // STN_cut_1727
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <-0.24044, -0.269588, -2.022777>
  }
  box { // STN_cut_1728
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  rotate <-143.341217, -265.857574, -145.304276>
  translate  27.0*y
}
#declare Base_Stone291 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone291 = difference {
  object { Base_Stone291 }
  box { // STN_cut_1734
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  sphere { // STN_cut_1735
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  rotate <1.411258, -173.943802, 1.766459>
  translate  18.0*y
}
#declare Base_Stone292 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone292 = difference {
  object { Base_Stone292 }
  cylinder { // STN_cut_1738
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1741
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.143285, -2.537716, 0.640442>
  }
  sphere { // STN_cut_1742
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    rotate <-22.580935, 18.102983, -31.194744>
    translate  <0.925582, 1.972248, 2.027057>
  }
  rotate <339.766876, -94.727737, -342.227539>
  translate  9.0*y
}
#declare W_Course42 = union {
  object { Stone288 }
  object { Stone289 }
  object { Stone290 }
  object { Stone291 }
  object { Stone292 }
}
#declare W_Mortar_hole1 = difference {
  box { // Mortar1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.6, 32.0, 50.0>
    translate  <0.0, 28.0, 47.0>
  }
  box { // Wall_Hole
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 6.0, 3.355087>
    translate  <0.0, 27.030105, 65.718733>
  }
  box { // Wall_Hole1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 6.0, 3.355087>
    translate  <0.0, 30.832168, 71.339172>
  }
  material {
    MEP_Mortar_1
  }
}
#declare Base_Stone294 = merge {
  sphere { <1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, 1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, 1.2500>, 0.7500 }
  sphere { <1.2500, 3.2500, -1.2500>, 0.7500 }
  sphere { <1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, -3.2500, -1.2500>, 0.7500 }
  sphere { <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, -1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, -3.2500, -1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, -3.2500, -1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, 3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, 1.2500>, <1.2500, -3.2500, 1.2500>, 0.7500 }
  cylinder { <1.2500, 3.2500, -1.2500>, <1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, -1.2500>, <-1.2500, -3.2500, -1.2500>, 0.7500 }
  cylinder { <-1.2500, 3.2500, 1.2500>, <-1.2500, -3.2500, 1.2500>, 0.7500 }
  box { <-1.2500, -3.2500, -2.0000> <1.2500, 3.2500, 2.0000> }
  box { <-1.2500, -4.0000, -1.2500> <1.2500, 4.0000, 1.2500> }
  box { <-2.0000, -3.2500, -1.2500> <2.0000, 3.2500, 1.2500> }
// Attributes returned success!
}
#declare Stone294 = difference {
  object { Base_Stone294 }
  box { // STN_cut_1749
    <-1, -1, -1>, <1, 1, 1>
    scale 0.307847
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <-2.212071, -2.28732, -0.822953>
  }
  cylinder { // STN_cut_1750
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
    rotate <45.823486, 19.790417, 13.827709>
    translate  <-2.058184, 2.234742, 0.681228>
  }
  sphere { // STN_cut_1751
    <0,0,0>,1
    scale <0.343245, 0.76891, 0.4>
    translate  <2.090523, -0.104837, 1.320013>
  }
  box { // STN_cut_1752
    <-1, -1, -1>, <1, 1, 1>
    scale <0.267178, 0.61542, 0.557623>
    rotate <-41.497849, 22.346512, -10.423798>
    translate  <2.087269, 2.139597, -1.053078>
  }
  rotate <-178.588745, -6.056198, -178.233536>
  translate  <-0.194208, 21.817738, 71.196527>
}
#declare Wall1 = union {
  object { W_Course22 }
  object { W_Course24 }
  object { W_Course25 }
  object { W_Course26 }
  object { W_Course27 }
  object { W_Course28 }
  object { W_Course29 }
  object { W_Course30 }
  object { W_Course31 }
  object { W_Course32 }
  object { W_Course33 }
  object { W_Course34 }
  object { W_Course35 }
  object { W_Course36 }
  object { W_Course37 }
  object { W_Course38 }
  object { W_Course39 }
  object { W_Course40 }
  object { W_Course41 }
  object { W_Course42 }
  object { W_Mortar_hole1 }
  object { Stone294 }
  material {
    RoughStone
  }
}
#declare Wall_and_Face_with_spot1 = union {
  plane { // MY_Screaming_Face
    z,0
    material {
      MEP_Scream
    }
    scale <8.0, 12.533333, 0.00001>
    rotate <90.0, 0.0, 90.0>
    translate  <2.95657, 25.544539, 63.547923>
  }
  object { Wall1 }
  box { // Wall_Backdrop
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black_Hole
    }
    scale <1.0, 10.0, 7.0>
    translate  <4.2839, 28.940706, 69.024874>
  }
  translate  <4.768769, 153.0, 3.5>
}
union { // Wall_Face_Arch
  object { Arches_and_shelves }
  object { Walls_and_Niches }
  object { Wall_and_Face_with_spot1 }
  hollow
  scale <1.0, 1.0, 1.25>
  rotate -8.136423*y
  translate  <174.806468, 132.807512, 0.0>
}


#declare SGW_FRAME = union {
  box { // SGW_FRAMER
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 98.0, 1.0>
    translate  <25.0, -40.0, 0.0>
  }
  box { // SGW_FRAMER1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 98.0, 1.0>
    translate  <-25.0, -40.0, 0.0>
  }
  box { // SGW_FRAMER2
    <-1, -1, -1>, <1, 1, 1>
    scale <26.0, 1.0, 1.0>
    translate  57.078303*y
  }
  box { // SGW_FRAMER3
    <-1, -1, -1>, <1, 1, 1>
    scale <26.0, 1.0, 1.0>
    translate  -137.0*y
  }
}
#declare SGW_J = difference {
  box { // SGW_JAW
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.5, 0.25>
    translate  -6.820779*y
  }
  box { // SGW_JAW1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 1.0, 0.25001>
    translate  -6.820779*y
  }
  cylinder { // SGW_HEAD2
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 0.501>
    translate  -0.2505*z
  }
  translate  0.239*y
}
#declare SGW_H = difference {
  cylinder { // SGW_HEAD
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 0.5>
    translate  -0.25*z
  }
  cylinder { // SGW_HEAD1
    <0,0,1>, <0,0,0>, 1 
    scale <5.5, 5.5, 0.5001>
    translate  -0.25005*z
  }
}
#declare SGW_EYE = difference {
  cylinder { // SGW_HEAD4
    <0,0,1>, <0,0,0>, 1 
    scale <5.75, 5.75, 0.5>
    translate  -0.25*z
  }
  cylinder { // SGW_HEAD3
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 0.6>
    translate  -0.2501*z
  }
  scale <0.3, 0.3, 1.0>
  translate  <-2.2, -1.57139, 0.0>
}
#declare SGW_EYE2 = difference {
  cylinder { // SGW_HEAD7
    <0,0,1>, <0,0,0>, 1 
    scale <5.75, 5.75, 0.5>
    translate  -0.25*z
  }
  cylinder { // SGW_HEAD8
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 0.6>
    translate  -0.2501*z
  }
  scale <0.3, 0.3, 1.0>
  translate  <2.196447, -1.569549, 0.0>
}
#declare SGW_SKULL = union {
  object { SGW_J }
  object { SGW_H }
  box { // SGW_TOOTH
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.25, 0.25>
    translate  <-1.514212, -6.72323, 0.0>
  }
  object { SGW_EYE }
  box { // SGW_NOSE
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 1.25, 0.25>
    translate  <-0.092435, -4.344432, 0.0>
  }
  object { SGW_EYE2 }
}
#declare SGW_RAYS = union {
  box { // SGW_RAY7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 96.0, 0.25>
    rotate -315.0*z
    translate  <-72.124892, 72.124892, 0.0>
  }
  box { // SGW_RAY6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 96.0, 0.25>
    rotate -270.0*z
    translate  <-102.0, 0.0, 0.0>
  }
  box { // SGW_RAY5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 96.0, 0.25>
    rotate -225.0*z
    translate  <-72.124892, -72.124892, 0.0>
  }
  box { // SGW_RAY4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 96.0, 0.25>
    rotate -180.0*z
    translate  -104.0*y
  }
  box { // SGW_RAY3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 96.0, 0.25>
    rotate -135.0*z
    translate  <72.124892, -72.124892, 0.0>
  }
  box { // SGW_RAY2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 96.0, 0.25>
    rotate -90.0*z
    translate  <102.0, -0.0, 0.0>
  }
  box { // SGW_RAY
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 96.0, 0.25>
    translate  102.0*y
  }
  box { // SGW_RAY1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 96.0, 0.25>
    rotate -45.0*z
    translate  <72.124892, 72.124892, 0.0>
  }
}
#declare SGW_W4 = difference {
  cylinder { // SGW_WEB5
    <0,0,1>, <0,0,0>, 1 
    scale <128.625, 128.625, 0.5>
    translate  -0.25*z
  }
  cylinder { // SGW_WEB8
    <0,0,1>, <0,0,0>, 1 
    scale <128.125, 128.125, 0.52>
    translate  -0.251*z
  }
}
#declare SGW_W3 = difference {
  cylinder { // SGW_WEB4
    <0,0,1>, <0,0,0>, 1 
    scale <73.5, 73.5, 0.5>
    translate  -0.25*z
  }
  cylinder { // SGW_WEB7
    <0,0,1>, <0,0,0>, 1 
    scale <73.0, 73.0, 0.52>
    translate  -0.251*z
  }
}
#declare SGW_W2 = difference {
  cylinder { // SGW_WEB3
    <0,0,1>, <0,0,0>, 1 
    scale <42.0, 42.0, 0.5>
    translate  -0.25*z
  }
  cylinder { // SGW_WEB6
    <0,0,1>, <0,0,0>, 1 
    scale <41.5, 41.5, 0.52>
    translate  -0.251*z
  }
}
#declare SGW_W = difference {
  cylinder { // SGW_WEB
    <0,0,1>, <0,0,0>, 1 
    scale <24.0, 24.0, 0.5>
    translate  -0.25*z
  }
  cylinder { // SGW_WEB1
    <0,0,1>, <0,0,0>, 1 
    scale <23.5, 23.5, 0.51>
    translate  -0.2505*z
  }
}
#declare SGW_WEBS = union {
  object { SGW_W4 }
  object { SGW_W3 }
  object { SGW_W2 }
  object { SGW_W }
  material {
    MEP_LEAD
  }
}
#declare SGW_GET_CLIPPED = union {
  object { SGW_RAYS }
  object { SGW_WEBS }
}
#declare SGW_CLIPPED_RAYS = difference {
  object { SGW_GET_CLIPPED }
  box { // SGW_CLIPPER
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 150.0, 1.0>
    translate  <-104.799378, 5.677646, 0.0>
  }
  box { // SGW_CLIPPER1
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 150.0, 1.0>
    translate  <104.79938, 5.677646, 0.0>
  }
}
#declare STAIN_GLASS_WINDOW = union {
  object { SGW_FRAME }
  object { SGW_SKULL }
  box { // SGW_GLASS
    <-1, -1, -1>, <1, 1, 1>
    material {
      MEP_RED_GLASS
    }
    scale <24.0, 96.0, 0.25>
    translate  <0.0, -40.0, -0.125>
  }
  object { SGW_CLIPPED_RAYS }
  material {
    MEP_LEAD
  }
}
union { // SGW_AND_AREA_LIGHT
  object { STAIN_GLASS_WINDOW }
  box { // SG_Wall
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black_Hole
    }
    scale 250.0
    rotate -90.0*x
    translate  <275.706683, -1.670585, -250.0>
  }
  box { // SG_Wall_2
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black_Hole
    }
    scale 250.0
    rotate -90.0*x
    translate  <-275.70668, -1.670585, -250.0>
  }
  scale <1.0, 1.0, 2.0>
  rotate <110.104492, -4.533875, 130.425934>
  translate  <74.565815, 207.980443, 122.975341>
}


#declare Crypt_Top = merge {
  sphere { <14.0000, 39.0000, 2.0000>, 1.0000 }
  sphere { <14.0000, -39.0000, 2.0000>, 1.0000 }
  sphere { <-14.0000, -39.0000, 2.0000>, 1.0000 }
  sphere { <-14.0000, 39.0000, 2.0000>, 1.0000 }
  sphere { <14.0000, 39.0000, -2.0000>, 1.0000 }
  sphere { <14.0000, -39.0000, -2.0000>, 1.0000 }
  sphere { <-14.0000, -39.0000, -2.0000>, 1.0000 }
  sphere { <-14.0000, 39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, 2.0000>, <-14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, 2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, -2.0000>, <-14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <-14.0000, 39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, -2.0000>, <14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <-14.0000, -39.0000, -2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, -2.0000>, <-14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, 2.0000>, <14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, -2.0000>, <-14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, 2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  box { <-14.0000, -39.0000, -3.0000> <14.0000, 39.0000, 3.0000> }
  box { <-14.0000, -40.0000, -2.0000> <14.0000, 40.0000, 2.0000> }
  box { <-15.0000, -39.0000, -2.0000> <15.0000, 39.0000, 2.0000> }
// Attributes returned success!
  rotate 90.0*z
}
#declare Poem_Text = union {
  text {   // TText001
    ttf      "C:\WINDOWS\Fonts\Bookosbi.ttf",
    "And all my days are trances, ",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate -90.0*z
    translate  <0.236375, 8.430713, 0.0>
  }

  text {   // TText002
    ttf      "C:\WINDOWS\Fonts\Bookosbi.ttf",
    "And all my nightly dreams",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate -90.0*z
    translate  <-1.124298, 7.68269, 0.0>
  }

  text {   // TText003
    ttf      "C:\WINDOWS\Fonts\Bookosbi.ttf",
    "Are where thy dark eye glances,",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate -90.0*z
    translate  <-2.386116, 8.881924, 0.0>
  }

  text {   // TText004
    ttf      "C:\WINDOWS\Fonts\Bookosbi.ttf",
    "And where thy footstep gleams -",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate -90.0*z
    translate  <-3.38612, 8.127062, 0.0>
  }

  text {   // TText005
    ttf      "C:\WINDOWS\Fonts\Bookosbi.ttf",
    "In what ethereal dances,",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate -90.0*z
    translate  <-4.38612, 5.0, 0.0>
  }

  text {   // TText006
    ttf      "C:\WINDOWS\Fonts\Bookosbi.ttf",
    "By what eternal streams.",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate -90.0*z
    translate  <-5.38612, 5.0, 0.0>
  }

  text {   // Nevermore
    ttf      "C:\WINDOWS\Fonts\Bookosbi.ttf",
    "Nevermore...",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <2.0, 2.75, 2.0>
    rotate -90.0*z
    translate  <20.0, 6.0, 0.0>
  }

  scale 1.45
  translate  <-28.547952, 0.0, 1.671172>
}
#declare My_Sig = union {
  text {   // My_Name
    ttf      "C:\WINDOWS\Fonts\Bookosbi.ttf",
    "Mark Poole",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    rotate <90.0, 0.0, -90.0>
    translate  <-39.288465, -5.984477, 0.07343>
  }

  text {   // Date
    ttf      "C:\WINDOWS\Fonts\Bookosbi.ttf",
    "Oct 31, 1999",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale 0.75
    rotate <90.0, 0.0, -90.0>
    translate  <-39.288465, -5.930277, -0.7>
  }

  translate  <0.0, 1.0, 0.129127>
}
#declare CPT_Inlay_Border = merge {
  sphere { <14.0000, 39.0000, 2.0000>, 1.0000 }
  sphere { <14.0000, -39.0000, 2.0000>, 1.0000 }
  sphere { <-14.0000, -39.0000, 2.0000>, 1.0000 }
  sphere { <-14.0000, 39.0000, 2.0000>, 1.0000 }
  sphere { <14.0000, 39.0000, -2.0000>, 1.0000 }
  sphere { <14.0000, -39.0000, -2.0000>, 1.0000 }
  sphere { <-14.0000, -39.0000, -2.0000>, 1.0000 }
  sphere { <-14.0000, 39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, 2.0000>, <-14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, 2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, -2.0000>, <-14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <-14.0000, 39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, -2.0000>, <14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <-14.0000, -39.0000, -2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, -2.0000>, <-14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, 2.0000>, <14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, -2.0000>, <-14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, 2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  box { <-14.0000, -39.0000, -3.0000> <14.0000, 39.0000, 3.0000> }
  box { <-14.0000, -40.0000, -2.0000> <14.0000, 40.0000, 2.0000> }
  box { <-15.0000, -39.0000, -2.0000> <15.0000, 39.0000, 2.0000> }
// Attributes returned success!
  scale <0.94, 0.975, 0.9>
  rotate 90.0*z
}
#declare CPT_Inlay_Border1 = merge {
  sphere { <14.0000, 39.0000, 2.0000>, 1.0000 }
  sphere { <14.0000, -39.0000, 2.0000>, 1.0000 }
  sphere { <-14.0000, -39.0000, 2.0000>, 1.0000 }
  sphere { <-14.0000, 39.0000, 2.0000>, 1.0000 }
  sphere { <14.0000, 39.0000, -2.0000>, 1.0000 }
  sphere { <14.0000, -39.0000, -2.0000>, 1.0000 }
  sphere { <-14.0000, -39.0000, -2.0000>, 1.0000 }
  sphere { <-14.0000, 39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, 2.0000>, <-14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, 2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, -2.0000>, <-14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <-14.0000, 39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, -2.0000>, <14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <-14.0000, -39.0000, -2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, -2.0000>, <-14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, 2.0000>, <14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, -2.0000>, <-14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, 2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  box { <-14.0000, -39.0000, -3.0000> <14.0000, 39.0000, 3.0000> }
  box { <-14.0000, -40.0000, -2.0000> <14.0000, 40.0000, 2.0000> }
  box { <-15.0000, -39.0000, -2.0000> <15.0000, 39.0000, 2.0000> }
// Attributes returned success!
  scale <0.91, 0.965, 1.0>
  rotate 90.0*z
}
#declare CPT_Inlay = difference {
  object { CPT_Inlay_Border }
  object { CPT_Inlay_Border1 }
  translate  2.0*z
}
#declare Crpt_Indent = merge {
  sphere { <14.0000, 0.0005, 2.0000>, 1.0000 }
  sphere { <14.0000, -0.0005, 2.0000>, 1.0000 }
  sphere { <-14.0000, -0.0005, 2.0000>, 1.0000 }
  sphere { <-14.0000, 0.0005, 2.0000>, 1.0000 }
  sphere { <14.0000, 0.0005, -2.0000>, 1.0000 }
  sphere { <14.0000, -0.0005, -2.0000>, 1.0000 }
  sphere { <-14.0000, -0.0005, -2.0000>, 1.0000 }
  sphere { <-14.0000, 0.0005, -2.0000>, 1.0000 }
  cylinder { <14.0000, 0.0005, 2.0000>, <-14.0000, 0.0005, 2.0000>, 1.0000 }
  cylinder { <14.0000, -0.0005, 2.0000>, <-14.0000, -0.0005, 2.0000>, 1.0000 }
  cylinder { <14.0000, -0.0005, -2.0000>, <-14.0000, -0.0005, -2.0000>, 1.0000 }
  cylinder { <14.0000, 0.0005, -2.0000>, <-14.0000, 0.0005, -2.0000>, 1.0000 }
  cylinder { <14.0000, 0.0005, -2.0000>, <14.0000, 0.0005, 2.0000>, 1.0000 }
  cylinder { <14.0000, -0.0005, -2.0000>, <14.0000, -0.0005, 2.0000>, 1.0000 }
  cylinder { <-14.0000, -0.0005, -2.0000>, <-14.0000, -0.0005, 2.0000>, 1.0000 }
  cylinder { <-14.0000, 0.0005, -2.0000>, <-14.0000, 0.0005, 2.0000>, 1.0000 }
  cylinder { <14.0000, 0.0005, 2.0000>, <14.0000, -0.0005, 2.0000>, 1.0000 }
  cylinder { <14.0000, 0.0005, -2.0000>, <14.0000, -0.0005, -2.0000>, 1.0000 }
  cylinder { <-14.0000, 0.0005, -2.0000>, <-14.0000, -0.0005, -2.0000>, 1.0000 }
  cylinder { <-14.0000, 0.0005, 2.0000>, <-14.0000, -0.0005, 2.0000>, 1.0000 }
  box { <-14.0000, -0.0005, -3.0000> <14.0000, 0.0005, 3.0000> }
  box { <-14.0000, -1.0005, -2.0000> <14.0000, 1.0005, 2.0000> }
  box { <-15.0000, -0.0005, -2.0000> <15.0000, 0.0005, 2.0000> }
// Attributes returned success!
  scale <0.8, 0.7, 0.7>
  rotate 90.0*z
  translate  -39.993909*x
}
#declare Crypt_Top_Inscribed = difference {
  object { Crypt_Top }
  object { Poem_Text }
  object { My_Sig }
  object { CPT_Inlay }
  text {   // Lenore
    ttf      "C:\WINDOWS\Fonts\Bookosb.ttf",
    "LENORE",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <5.0, 7.0, 5.0>
    rotate -90.0*z
    translate  <5.501903, 10.644636, 0.0>
  }

  object { Crpt_Indent }
}
#declare WB_Lower = difference {
  cylinder { // WB_Bott_OUT
    <0,0,1>, <0,0,0>, 1 
    scale <2.0091, 2.0091, 7.0>
  }
  cylinder { // WB_Bott_In
    <0,0,1>, <0,0,0>, 1 
    material {
      MEP_Dark_Green_Glass
    }
    scale <1.8, 1.8, 6.8>
  }
  translate  0.5*z
}
#declare WB_Label_Round = difference {
  cylinder { // WB_Label_OUT
    <0,0,1>, <0,0,0>, 1 
    scale <2.1, 2.1, 4.0>
    translate  -2.0*z
  }
  cylinder { // WB_Label_IN
    <0,0,1>, <0,0,0>, 1 
    scale <1.999, 1.999, 4.3>
    translate  -2.15*z
  }
}
#declare WB_Label = difference {
  object { WB_Label_Round }
  box { // WB_Label_Cutter
    <-1, -1, -1>, <1, 1, 1>
    scale <1.71, 2.15, 2.15>
    translate  -0.461996*x
  }
  material {
    Poe_Wine_Label
  }
  scale <1.0, 1.0, 1.2>
  rotate -119.361267*z
  translate  4.0*z
}
#declare WB_Shoulder = difference {
  sphere { // WB_Shoulder_OUT
    <0,0,0>,1
    scale 2.009
  }
  sphere { // WB_Shoulder_IN
    <0,0,0>,1
    scale 1.81
  }
  translate  7.5*z
}
#declare WB_Neck = difference {
  cone { // WB_Neck_Out
    <0,0,0>, 0.75, <0,0,1>, 0.5
    scale <1.0, 1.0, 4.0>
    translate  9.0*z
  }
  cone { // WB_Neck_IN
    <0,0,0>, 0.75, <0,0,1>, 0.5
    scale <0.8, 0.8, 4.01>
    translate  9.0*z
  }
}
#declare WB_Cork_Hole = difference {
  sphere { // WB_Cork_Hole_Out
    <0,0,0>,1
    scale <0.7, 0.7, 1.15>
    translate  <0.0, -0.009625, 13.461996>
  }
  box { // WB_CH_Cut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.75, 0.5>
    translate  14.31087*z
  }
  sphere { // WB_Cork_Hole_IN
    <0,0,0>,1
    scale <0.5, 0.5, 0.821429>
    translate  <0.0, -0.009625, 13.461996>
  }
}
#declare Wine_Bottle = merge {
  object { WB_Lower }
  torus { // WB_Bot_Rim
    1.5, 0.5  rotate -x*90
    scale 1.05
    translate  0.5*z
  }
  object { WB_Label }
  object { WB_Shoulder }
  object { WB_Neck }
  object { WB_Cork_Hole }
  torus { // WB_Rim
    1.375, 0.25  rotate -x*90
    scale <0.45, 0.42, 0.45>
    translate  13.927846*z
  }
  material {
    MEP_Dark_Green_Glass
  }
  rotate 60.0*z
  translate  <0.05022, -6.588133, 0.0>
}
#declare WG_Wine_Puddle = merge {
  sphere { // WG_Puddle1
    <0,0,0>,1
    scale <3.698473, 4.39487, 0.25>
    rotate 67.141983*z
    translate  <7.380719, -10.067479, 0.0>
  }
  sphere { // WG_Puddle2
    <0,0,0>,1
    scale <5.19859, 5.02725, 0.25>
    rotate 67.141983*z
    translate  <15.520523, -9.70571, 0.0>
  }
  sphere { // WG_Puddle
    <0,0,0>,1
    scale <8.0, 10.0, 0.25>
    rotate 67.141983*z
    translate  <10.376232, -3.176398, 0.0>
  }
  material {
    MEP_Wine
  }
  scale 0.624524
  rotate 90.0*z
  translate  <7.0, -7.0, -0.2>
}
#declare WG_Body_Outer = merge {
  cone { // WG_Flute
    <0,0,0>, 1.25, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.5>
  }
  sphere { // WG_B_Bot
    <0,0,0>,1
    scale 1.251
  }
}
#declare WG_Body_Inner = merge {
  cone { // WG_Flute1
    <0,0,0>, 1.25, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.8>
  }
  sphere { // WG_B_Bot1
    <0,0,0>,1
    scale <1.25, 1.25, 1.08>
  }
  scale 0.9
}
#declare WG_Body = difference {
  object { WG_Body_Outer }
  object { WG_Body_Inner }
}
#declare WG_Foot_Obj = difference {
  sphere { // WG_Foot
    <0,0,0>,1
    scale <1.25, 1.25, 0.2>
    translate  -4.277235*z
  }
  sphere { // WG_Foot1
    <0,0,0>,1
    scale <1.580549, 1.580549, 0.252888>
    translate  <0.0, -0.008162, -4.440469>
  }
}
#declare WG_Wine = merge {
  cone { // WG_Flute2
    <0,0,0>, 1.25, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.8>
  }
  sphere { // WG_B_Bot2
    <0,0,0>,1
    scale <1.25, 1.25, 1.08>
  }
  scale 0.888889
}
#declare WG_Wine_LVL = difference {
  object { WG_Wine }
  cylinder { // WG_Wine_Leveler
    <0,0,1>, <0,0,0>, 1 
    scale <1.1, 1.1, 1.6>
    translate  1.0*z
  }
  material {
    MEP_Wine
  }
}
#declare Wine_Glass = merge {
  torus { // WG_Top_Rim
    1.5, 0.05  rotate -x*90
    scale 0.662503
    translate  2.535*z
  }
  object { WG_Body }
  cone { // WG_Stem
    <0,0,0>, 0.125, <0,0,1>, 0.25
    scale <1.0, 1.0, 1.52>
    translate  -2.7*z
  }
  cone { // WG_Stem1
    <0,0,0>, 0.125, <0,0,1>, 0.25
    scale <1.0, 1.0, 1.52>
    rotate <180.0, 0.0, 180.0>
    translate  -2.68*z
  }
  torus { // WG_Bot_Rim
    1.5, 0.05  rotate -x*90
    scale 0.8
    translate  -4.25*z
  }
  object { WG_Foot_Obj }
  object { WG_Wine_LVL }
  material {
    Glass
  }
  translate  <3.0, -3.0, 4.32443>
}
#declare WG_Body_Outer1 = merge {
  cone { // WG_Flute3
    <0,0,0>, 1.25, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.5>
  }
  sphere { // WG_B_Bot3
    <0,0,0>,1
    scale 1.25
  }
}
#declare WG_Body_Inner1 = merge {
  cone { // WG_Flute4
    <0,0,0>, 1.25, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.8>
  }
  sphere { // WG_B_Bot4
    <0,0,0>,1
    scale <1.25, 1.25, 1.08>
  }
  scale 0.9
}
#declare WG_Body1 = difference {
  object { WG_Body_Outer1 }
  object { WG_Body_Inner1 }
}
#declare WG_Foot_Obj1 = difference {
  sphere { // WG_Foot2
    <0,0,0>,1
    scale <1.25, 1.25, 0.2>
    translate  -4.277235*z
  }
  sphere { // WG_Foot3
    <0,0,0>,1
    scale <1.580549, 1.580549, 0.252888>
    translate  <0.0, -0.008162, -4.440469>
  }
}
#declare Wine_Glass1 = merge {
  torus { // WG_Top_Rim1
    1.5, 0.05  rotate -x*90
    scale 0.662503
    translate  2.535*z
  }
  object { WG_Body1 }
  cone { // WG_Stem2
    <0,0,0>, 0.125, <0,0,1>, 0.25
    scale <1.0, 1.0, 1.52>
    translate  -2.7*z
  }
  cone { // WG_Stem3
    <0,0,0>, 0.125, <0,0,1>, 0.25
    scale <1.0, 1.0, 1.52>
    rotate <180.0, 0.0, 180.0>
    translate  -2.68*z
  }
  torus { // WG_Bot_Rim1
    1.5, 0.05  rotate -x*90
    scale 0.8
    translate  -4.25*z
  }
  object { WG_Foot_Obj1 }
  material {
    Glass
  }
  rotate <-85.0, -269.486115, -28.969616>
  translate  <7.0, -8.0, 1.163083>
}
#declare Wine_Bottle_Glasses = union {
  object { Wine_Bottle }
  object { WG_Wine_Puddle }
  object { Wine_Glass }
  object { Wine_Glass1 }
  rotate -100.0*z
  translate  <-18.0, 6.885707, 3.15747>
}
#declare TRWL_Blade = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  12  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, -0.0>,
  <0.860403, 1.005626>,
  <0.713376, 1.52017>,
  <0.521868, 2.010085>,
  <0.0, 2.985138>,
  <-0.505308, 2.0138>,
  <-0.692144, 1.530786>,
  <-0.835987, 1.012527>,
  <-1.0, 0.0>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.52461, 1.905762, 0.05>
  rotate -85.0*x
  translate  <0.0, -1.253577, -2.982906>
}
#declare Trowel = union {
  sphere { // TRWL_H_End
    <0,0,0>,1
    material {
      BallWood_1
    }
    scale 0.501
    translate  4.0*z
  }
  cone { // TRWL_H_Grip
    <0,0,0>, 0.4, <0,0,1>, 0.5
    material {
      BallWood_1
    }
    scale <1.0, 1.0, 4.0>
  }
  cone { // TRWL_H_Cap
    <0,0,0>, 0.41, <0,0,1>, 0.447
    translate  -0.1*z
  }
  cylinder { // TRWL_Met_Hand1
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 1.55>
    rotate -58.735615*x
    translate  <0.0, -1.29344, -2.236624>
  }
  cylinder { // TRWL_Met_Hand2
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 1.49>
    rotate -0.0*x
    translate  <0.0, -0.018033, -1.540393>
  }
  cylinder { // TRWL_Met_Hand
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.05, 1.5>
    rotate -175.0*x
    translate  <0.0, -1.268847, -2.20825>
  }
  sphere { // TWRL_Rivet1
    <0,0,0>,1
    scale <0.1, 0.1, 0.047>
    rotate -85.0*x
    translate  <0.0, -1.200264, -2.52421>
  }
  sphere { // TWRL_Rivet
    <0,0,0>,1
    scale <0.1, 0.1, 0.047>
    rotate -85.0*x
    translate  <0.0, -1.155339, -3.275>
  }
  object { TRWL_Blade }
  material {
    Streaky_Steel_Metal
  }
  rotate <-95.0, -60.240021, 152.016891>
  translate  <-21.100952, -8.572291, 3.727028>
}
#declare Objects_on_Table = union {
  object { Wine_Bottle_Glasses }
  object { Trowel }
  rotate 13.203669*z
  translate  <-2.030386, 7.986184, 0.0>
}
#declare Crypt_Inner_Gold = merge {
  sphere { <14.0000, 39.0000, 2.0000>, 1.0000 }
  sphere { <14.0000, -39.0000, 2.0000>, 1.0000 }
  sphere { <-14.0000, -39.0000, 2.0000>, 1.0000 }
  sphere { <-14.0000, 39.0000, 2.0000>, 1.0000 }
  sphere { <14.0000, 39.0000, -2.0000>, 1.0000 }
  sphere { <14.0000, -39.0000, -2.0000>, 1.0000 }
  sphere { <-14.0000, -39.0000, -2.0000>, 1.0000 }
  sphere { <-14.0000, 39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, 2.0000>, <-14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, 2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, -2.0000>, <-14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <-14.0000, 39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, -2.0000>, <14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <-14.0000, -39.0000, -2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, -2.0000>, <-14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, 2.0000>, <14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, -2.0000>, <-14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, 2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  box { <-14.0000, -39.0000, -3.0000> <14.0000, 39.0000, 3.0000> }
  box { <-14.0000, -40.0000, -2.0000> <14.0000, 40.0000, 2.0000> }
  box { <-15.0000, -39.0000, -2.0000> <15.0000, 39.0000, 2.0000> }
// Attributes returned success!
  material {
    Brass_Metal
  }
  scale 0.98
  rotate 90.0*z
}
#declare Crypt_Bottom = merge {
  sphere { <13.5000, 38.5000, 11.0000>, 1.0000 }
  sphere { <13.5000, -38.5000, 11.0000>, 1.0000 }
  sphere { <-13.5000, -38.5000, 11.0000>, 1.0000 }
  sphere { <-13.5000, 38.5000, 11.0000>, 1.0000 }
  sphere { <13.5000, 38.5000, -11.0000>, 1.0000 }
  sphere { <13.5000, -38.5000, -11.0000>, 1.0000 }
  sphere { <-13.5000, -38.5000, -11.0000>, 1.0000 }
  sphere { <-13.5000, 38.5000, -11.0000>, 1.0000 }
  cylinder { <13.5000, 38.5000, 11.0000>, <-13.5000, 38.5000, 11.0000>, 1.0000 }
  cylinder { <13.5000, -38.5000, 11.0000>, <-13.5000, -38.5000, 11.0000>, 1.0000 }
  cylinder { <13.5000, -38.5000, -11.0000>, <-13.5000, -38.5000, -11.0000>, 1.0000 }
  cylinder { <13.5000, 38.5000, -11.0000>, <-13.5000, 38.5000, -11.0000>, 1.0000 }
  cylinder { <13.5000, 38.5000, -11.0000>, <13.5000, 38.5000, 11.0000>, 1.0000 }
  cylinder { <13.5000, -38.5000, -11.0000>, <13.5000, -38.5000, 11.0000>, 1.0000 }
  cylinder { <-13.5000, -38.5000, -11.0000>, <-13.5000, -38.5000, 11.0000>, 1.0000 }
  cylinder { <-13.5000, 38.5000, -11.0000>, <-13.5000, 38.5000, 11.0000>, 1.0000 }
  cylinder { <13.5000, 38.5000, 11.0000>, <13.5000, -38.5000, 11.0000>, 1.0000 }
  cylinder { <13.5000, 38.5000, -11.0000>, <13.5000, -38.5000, -11.0000>, 1.0000 }
  cylinder { <-13.5000, 38.5000, -11.0000>, <-13.5000, -38.5000, -11.0000>, 1.0000 }
  cylinder { <-13.5000, 38.5000, 11.0000>, <-13.5000, -38.5000, 11.0000>, 1.0000 }
  box { <-13.5000, -38.5000, -12.0000> <13.5000, 38.5000, 12.0000> }
  box { <-13.5000, -39.5000, -11.0000> <13.5000, 39.5000, 11.0000> }
  box { <-14.5000, -38.5000, -11.0000> <14.5000, 38.5000, 11.0000> }
// Attributes returned success!
  rotate 90.0*z
  translate  -14.0*z
}
#declare Crypt_Sig_Color = merge {
  sphere { <14.0000, 39.0000, 2.0000>, 1.0000 }
  sphere { <14.0000, -39.0000, 2.0000>, 1.0000 }
  sphere { <-14.0000, -39.0000, 2.0000>, 1.0000 }
  sphere { <-14.0000, 39.0000, 2.0000>, 1.0000 }
  sphere { <14.0000, 39.0000, -2.0000>, 1.0000 }
  sphere { <14.0000, -39.0000, -2.0000>, 1.0000 }
  sphere { <-14.0000, -39.0000, -2.0000>, 1.0000 }
  sphere { <-14.0000, 39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, 2.0000>, <-14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, 2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, -2.0000>, <-14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <-14.0000, 39.0000, -2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, -39.0000, -2.0000>, <14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <-14.0000, -39.0000, -2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, -2.0000>, <-14.0000, 39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, 2.0000>, <14.0000, -39.0000, 2.0000>, 1.0000 }
  cylinder { <14.0000, 39.0000, -2.0000>, <14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, -2.0000>, <-14.0000, -39.0000, -2.0000>, 1.0000 }
  cylinder { <-14.0000, 39.0000, 2.0000>, <-14.0000, -39.0000, 2.0000>, 1.0000 }
  box { <-14.0000, -39.0000, -3.0000> <14.0000, 39.0000, 3.0000> }
  box { <-14.0000, -40.0000, -2.0000> <14.0000, 40.0000, 2.0000> }
  box { <-15.0000, -39.0000, -2.0000> <15.0000, 39.0000, 2.0000> }
// Attributes returned success!
  material {
    Brass_Metal
  }
  scale <0.98, 0.9823, 0.8>
  rotate 90.0*z
}
union { // Crypt_and_objects
  object { Crypt_Top_Inscribed }
  object { Objects_on_Table }
  object { Crypt_Inner_Gold }
  object { Crypt_Bottom }
  object { Crypt_Sig_Color }
  material {
    Black_Vein_Granit
  }
  rotate <-0.442861, -9.549397, 8.717666>
  translate  <103.730056, 345.3273, 41.714437>
}


#declare Granite_Course7 = union {
  box { // Granite_Block57
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  255.5*y
  }
  box { // Granite_Block58
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  219.0*y
  }
  box { // Granite_Block59
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  182.5*y
  }
  box { // Granite_Block60
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -0.0*y
    translate  146.0*y
  }
  box { // Granite_Block61
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  109.5*y
  }
  box { // Granite_Block62
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  73.0*y
  }
  box { // Granite_Block63
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  36.5*y
  }
  box { // Granite_Block64
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
  }
  rotate <180.0, 0.0, 180.0>
  translate  147.0*z
}
#declare Granite_Course8 = union {
  box { // Granite_Block65
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  255.5*y
  }
  box { // Granite_Block66
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  219.0*y
  }
  box { // Granite_Block67
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  182.5*y
  }
  box { // Granite_Block68
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -0.0*y
    translate  146.0*y
  }
  box { // Granite_Block69
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  109.5*y
  }
  box { // Granite_Block70
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  73.0*y
  }
  box { // Granite_Block71
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  36.5*y
  }
  box { // Granite_Block72
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
  }
  rotate -90.0*y
  translate  <0.0, 18.25, 122.5>
}
#declare Granite_Course9 = union {
  box { // Granite_Block73
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  255.5*y
  }
  box { // Granite_Block74
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  219.0*y
  }
  box { // Granite_Block75
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  182.5*y
  }
  box { // Granite_Block76
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -0.0*y
    translate  146.0*y
  }
  box { // Granite_Block77
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  109.5*y
  }
  box { // Granite_Block78
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  73.0*y
  }
  box { // Granite_Block79
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  36.5*y
  }
  box { // Granite_Block80
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
  }
  rotate -0.0*y
  translate  98.0*z
}
#declare Granite_Course10 = union {
  box { // Granite_Block81
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  255.5*y
  }
  box { // Granite_Block82
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  219.0*y
  }
  box { // Granite_Block83
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  182.5*y
  }
  box { // Granite_Block84
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -0.0*y
    translate  146.0*y
  }
  box { // Granite_Block85
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  109.5*y
  }
  box { // Granite_Block86
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  73.0*y
  }
  box { // Granite_Block87
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  36.5*y
  }
  box { // Granite_Block88
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
  }
  rotate 90.0*y
  translate  <0.0, 18.25, 73.5>
}
#declare Granite_Course11 = union {
  box { // Granite_Block89
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  255.5*y
  }
  box { // Granite_Block90
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  219.0*y
  }
  box { // Granite_Block91
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  182.5*y
  }
  box { // Granite_Block92
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -0.0*y
    translate  146.0*y
  }
  box { // Granite_Block93
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  109.5*y
  }
  box { // Granite_Block94
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  73.0*y
  }
  box { // Granite_Block95
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  36.5*y
  }
  box { // Granite_Block96
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
  }
  rotate <180.0, 0.0, 180.0>
  translate  49.0*z
}
#declare Granite_Course12 = union {
  box { // Granite_Block97
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  255.5*y
  }
  box { // Granite_Block98
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  219.0*y
  }
  box { // Granite_Block99
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  182.5*y
  }
  box { // Granite_Block100
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -0.0*y
    translate  146.0*y
  }
  box { // Granite_Block101
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  109.5*y
  }
  box { // Granite_Block102
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  73.0*y
  }
  box { // Granite_Block103
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  36.5*y
  }
  box { // Granite_Block104
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
  }
  rotate -90.0*y
  translate  <0.0, 18.25, 24.5>
}
#declare Granite_Course13 = union {
  box { // Granite_Block105
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  255.5*y
  }
  box { // Granite_Block106
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  219.0*y
  }
  box { // Granite_Block107
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  182.5*y
  }
  box { // Granite_Block108
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -0.0*y
    translate  146.0*y
  }
  box { // Granite_Block109
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate 90.0*y
    translate  109.5*y
  }
  box { // Granite_Block110
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate <180.0, 0.0, 180.0>
    translate  73.0*y
  }
  box { // Granite_Block111
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
    rotate -90.0*y
    translate  36.5*y
  }
  box { // Granite_Block112
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 18.0, 12.0>
  }
}
#declare Floor = union {
  object { Granite_Course7 }
  object { Granite_Course8 }
  object { Granite_Course9 }
  object { Granite_Course10 }
  object { Granite_Course11 }
  object { Granite_Course12 }
  object { Granite_Course13 }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    material {
      MEP_Stone
    }
    scale <99.5, 200.0, 100.0>
    rotate <-0.0, -0.0, -0.0>
    translate  <88.0, 150.0, 88.0>
  }
  scale <1.5, 1.5, 2.0>
  rotate <-33.103519, 90.0, 0.0>
  translate  <82.851372, -46.686889, -18.0>
}
#declare Pit_in_Floor = difference {
  object { Floor }
  cylinder { // Pit
    <0,0,1>, <0,0,0>, 1 
    material {
      MEP_Stone
    }
    scale <50.0, 50.0, 301.0>
    translate  <89.169562, 264.143249, -300.999>
  }
}
#declare Pit_Rim = union {
  torus { // Arch_10
    24.0, 6.0  rotate -x*90
    rotate <0.0, -90.0, 0.0>
  }
  torus { // Arch_11
    24.0, 3.0  rotate -x*90
    rotate -90.0*y
    translate  -5.0*x
  }
  scale <0.25, 2.5, 2.5>
  rotate 90.0*y
  translate  <91.231835, 262.491322, 0.0>
}
union { // Floor_and_Pit
  object { Pit_in_Floor }
  object { Pit_Rim }
  material {
    Black_Vein_Granit
  }
  translate  <1.064163, -2.660407, 0.0>
}




box { // Sig_Cube
  <-1, -1, -1>, <1, 1, 1>
  material {
    MEP_RED_GLASS
  }
  scale 5.0
  rotate <-0.0, -11.132361, 10.799185>
  translate  <49.86426, 329.255504, 33.334594>
}


#declare MSQ_Right_Arm = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.098103, -2.701046, -8.180310>, <-2.538448, 1.703280, -18.131395>, <2.538448, 1.706053, -18.114997>, <2.978793, -2.698276, -8.163912>, 
      <-2.324827, -1.934768, -0.540244>, <-2.104654, 2.209931, -1.751859>, <2.972242, 2.212705, -1.735462>, <2.752069, -1.153119, -1.043099>, 
      <-3.436750, -0.562696, 1.534388>, <-2.551550, 1.851162, -0.859959>, <2.525345, 2.546272, -0.497394>, <1.640146, -0.213757, 1.723870>, 
      <-3.885901, -0.052967, 4.196814>, <-3.443301, 2.853142, 2.596114>, <1.633595, 3.201436, 2.785679>, <1.190995, 0.122240, 4.299838>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.978793, -2.698276, -8.163912>, <3.419138, -7.102605, 1.787174>, <-1.657758, -7.105372, 1.770776>, <-2.098103, -2.701046, -8.180310>, 
      <2.752069, -1.153119, -1.043099>, <2.531897, -4.518943, -0.350737>, <-2.544999, -6.079468, 0.671370>, <-2.324827, -1.934768, -0.540244>, 
      <1.640146, -0.213757, 1.723870>, <0.754947, -2.973787, 3.945133>, <-4.321949, -2.976553, 3.928735>, <-3.436750, -0.562696, 1.534388>, 
      <1.190995, 0.122240, 4.299838>, <0.748396, -2.956957, 5.813996>, <-4.328500, -2.959076, 5.797514>, <-3.885901, -0.052967, 4.196814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.885901, -0.052967, 4.196814>, <-3.443301, 2.853142, 2.596114>, <1.633595, 3.201436, 2.785679>, <1.190995, 0.122240, 4.299838>, 
      <-4.335051, 0.456762, 6.859241>, <-4.335051, 3.855122, 6.052188>, <0.741844, 3.856600, 6.068752>, <0.741844, 0.458237, 6.875805>, 
      <-4.341603, 0.461436, 9.370567>, <-4.341603, 3.686712, 9.082767>, <0.735293, 3.688190, 9.099332>, <0.735293, 0.462910, 9.387132>, 
      <-3.972158, 0.230720, 11.753353>, <-3.972158, 3.462404, 11.609453>, <0.727886, 3.463143, 10.370312>, <0.727886, 0.231455, 10.514212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.190995, 0.122240, 4.299838>, <0.748396, -2.956957, 5.813996>, <-4.328500, -2.959076, 5.797514>, <-3.885901, -0.052967, 4.196814>, 
      <0.741844, 0.458237, 6.875805>, <0.741844, -2.940127, 7.682858>, <-4.335051, -2.941598, 7.666293>, <-4.335051, 0.456762, 6.859241>, 
      <0.735293, 0.462910, 9.387132>, <0.735293, -2.762369, 9.674932>, <-4.341603, -2.763840, 9.658367>, <-4.341603, 0.461436, 9.370567>, 
      <0.727886, 0.231455, 10.514212>, <0.727886, -3.000232, 10.658112>, <-3.972158, -3.000964, 11.897253>, <-3.972158, 0.230720, 11.753353>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.972158, 0.230720, 11.753353>, <-3.972158, 3.462404, 11.609453>, <0.727886, 3.463143, 10.370312>, <0.727886, 0.231455, 10.514212>, 
      <-3.602713, 0.000004, 14.136138>, <-3.602713, 3.238095, 14.136138>, <0.720479, 3.238095, 11.641292>, <0.720479, 0.000000, 11.641292>, 
      <-2.398038, 0.000004, 16.449456>, <-2.398038, 3.238095, 16.449456>, <1.925154, 3.238095, 13.954610>, <1.925154, 0.000000, 13.954610>, 
      <-1.557965, 0.000004, 18.851118>, <-1.557965, 3.238095, 18.851118>, <2.858418, 3.238095, 16.546233>, <2.858418, 0.000000, 16.546233>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.727886, 0.231455, 10.514212>, <0.727886, -3.000232, 10.658112>, <-3.972158, -3.000964, 11.897253>, <-3.972158, 0.230720, 11.753353>, 
      <0.720479, 0.000000, 11.641292>, <0.720479, -3.238094, 11.641292>, <-3.602713, -3.238087, 14.136138>, <-3.602713, 0.000004, 14.136138>, 
      <1.925154, 0.000000, 13.954610>, <1.925154, -3.238094, 13.954610>, <-2.398038, -3.238087, 16.449456>, <-2.398038, 0.000004, 16.449456>, 
      <2.858418, 0.000000, 16.546233>, <2.858418, -3.238094, 16.546233>, <-1.557965, -3.238087, 18.851118>, <-1.557965, 0.000004, 18.851118>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.557965, 0.000004, 18.851118>, <-1.557965, 3.238095, 18.851118>, <2.858418, 3.238095, 16.546233>, <2.858418, 0.000000, 16.546233>, 
      <-0.717892, 0.000004, 21.252779>, <-0.717892, 3.238095, 21.252779>, <3.791681, 3.238095, 19.137856>, <3.791681, 0.000000, 19.137856>, 
      <-0.400795, 0.000004, 25.820892>, <-0.400795, 3.238095, 25.820892>, <4.885189, 3.238095, 21.509191>, <4.885189, 0.000000, 21.509191>, 
      <3.259514, 0.000004, 26.363599>, <3.259514, 3.238095, 26.363599>, <4.940471, 3.238095, 21.988983>, <4.940471, 0.000000, 21.988983>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.858418, 0.000000, 16.546233>, <2.858418, -3.238094, 16.546233>, <-1.557965, -3.238087, 18.851118>, <-1.557965, 0.000004, 18.851118>, 
      <3.791681, 0.000000, 19.137856>, <3.791681, -3.238094, 19.137856>, <-0.717892, -3.238087, 21.252779>, <-0.717892, 0.000004, 21.252779>, 
      <4.885189, 0.000000, 21.509191>, <4.885189, -3.238094, 21.509191>, <-0.400795, -3.238087, 25.820892>, <-0.400795, 0.000004, 25.820892>, 
      <4.940471, 0.000000, 21.988983>, <4.940471, -3.238094, 21.988983>, <3.259514, -3.238087, 26.363599>, <3.259514, 0.000004, 26.363599>
    }
  }
  scale <1.0, 1.0, 0.75>
  rotate -168.168213*z
  translate  <9.464395, 2.859455, 0.0>
}
#declare MSQ_Left_Arm = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.118210, -8.485018, -3.589565>, <-5.917443, -9.608023, -14.272154>, <-9.976056, -6.616066, -13.679700>, <-8.176825, -5.493064, -2.997108>, 
      <-0.473134, -5.034022, 2.225349>, <0.664275, -2.468921, -1.064267>, <-3.394338, 0.523036, -0.471813>, <-4.404268, -1.700536, 1.955611>, 
      <1.866305, -3.894522, 3.032578>, <1.230823, -2.628744, -0.182566>, <-2.383686, 0.988684, 0.306357>, <-1.970257, -0.589832, 3.573270>, 
      <3.888188, -2.560447, 4.280265>, <3.798033, -1.069946, 1.990728>, <-0.038777, 2.234324, 2.531848>, <-0.298323, -0.159957, 4.898754>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.176825, -5.493064, -2.997108>, <-6.377593, -4.370062, 7.685483>, <-2.318977, -7.362014, 7.093024>, <-4.118210, -8.485018, -3.589565>, 
      <-4.404268, -1.700536, 1.955611>, <-5.414198, -3.924107, 4.383035>, <-1.610543, -7.599124, 5.514965>, <-0.473134, -5.034022, 2.225349>, 
      <-1.970257, -0.589832, 3.573270>, <-1.556829, -2.168347, 6.840183>, <2.501787, -5.160299, 6.247723>, <1.866305, -3.894522, 3.032578>, 
      <-0.298323, -0.159957, 4.898754>, <-0.602705, -2.554237, 7.275385>, <3.938401, -4.050949, 6.612197>, <3.888188, -2.560447, 4.280265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.888188, -2.560447, 4.280265>, <3.798033, -1.069946, 1.990728>, <-0.038777, 2.234324, 2.531848>, <-0.298323, -0.159957, 4.898754>, 
      <5.870129, -1.226372, 5.570347>, <6.365242, 0.488853, 4.164023>, <2.306132, 3.479964, 4.757340>, <1.328776, 0.269918, 6.233963>, 
      <5.622366, 0.461436, 8.662912>, <5.581691, 3.686712, 8.378001>, <0.558095, 3.688190, 9.111916>, <0.598770, 0.462910, 9.396828>, 
      <5.641847, 0.230720, 11.053794>, <5.573051, 3.462404, 10.931539>, <0.745055, 3.463143, 10.369092>, <0.807222, 0.231455, 10.508043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.298323, -0.159957, 4.898754>, <-0.602705, -2.554237, 7.275385>, <3.938401, -4.050949, 6.612197>, <3.888188, -2.560447, 4.280265>, 
      <1.328776, 0.269918, 6.233963>, <0.351420, -2.940127, 7.710587>, <5.375015, -2.941598, 6.976671>, <5.870129, -1.226372, 5.570347>, 
      <0.598770, 0.462910, 9.396828>, <0.639445, -2.762369, 9.681740>, <5.663041, -2.763840, 8.947824>, <5.622366, 0.461436, 8.662912>, 
      <0.807222, 0.231455, 10.508043>, <0.785730, -3.000232, 10.654004>, <5.613725, -3.000964, 11.216450>, <5.641847, 0.230720, 11.053794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.641847, 0.230720, 11.053794>, <5.573051, 3.462404, 10.931539>, <0.745055, 3.463143, 10.369092>, <0.807222, 0.231455, 10.508043>, 
      <5.564410, 0.000004, 13.485076>, <5.564410, 3.238095, 13.485076>, <0.932015, 3.238095, 11.626268>, <0.932015, 0.000000, 11.626268>, 
      <4.698769, 0.000004, 15.945431>, <4.698769, 3.238095, 15.945431>, <0.066374, 3.238095, 14.086623>, <0.066374, 0.000000, 14.086623>, 
      <4.281859, 0.000004, 18.428075>, <4.206554, 3.238095, 18.441713>, <-0.491248, 3.238095, 16.784131>, <-0.421123, 0.000000, 16.787653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.807222, 0.231455, 10.508043>, <0.785730, -3.000232, 10.654004>, <5.613725, -3.000964, 11.216450>, <5.641847, 0.230720, 11.053794>, 
      <0.932015, 0.000000, 11.626268>, <0.932015, -3.238094, 11.626268>, <5.564410, -3.238087, 13.485076>, <5.564410, 0.000004, 13.485076>, 
      <0.066374, 0.000000, 14.086623>, <0.066374, -3.238094, 14.086623>, <4.698769, -3.238087, 15.945431>, <4.698769, 0.000004, 15.945431>, 
      <-0.421123, 0.000000, 16.787653>, <-0.491248, -3.238094, 16.784131>, <4.206554, -3.238087, 18.441713>, <4.281859, 0.000004, 18.428075>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.281859, 0.000004, 18.428075>, <4.206554, 3.238095, 18.441713>, <-0.491248, 3.238095, 16.784131>, <-0.421123, 0.000000, 16.787653>, 
      <3.714340, 0.000004, 20.937996>, <3.714340, 3.238095, 20.937996>, <-1.048870, 3.238095, 19.481638>, <-1.048870, 0.000000, 19.481638>, 
      <4.046037, 0.000004, 25.505071>, <4.046037, 3.238095, 25.505071>, <-1.796262, 3.238095, 21.983717>, <-1.796262, 0.000000, 21.983717>, 
      <0.499169, 0.000004, 26.559643>, <0.499169, 3.238095, 26.559643>, <-1.783179, 3.238095, 22.466506>, <-1.783179, 0.000000, 22.466506>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.421123, 0.000000, 16.787653>, <-0.491248, -3.238094, 16.784131>, <4.206554, -3.238087, 18.441713>, <4.281859, 0.000004, 18.428075>, 
      <-1.048870, 0.000000, 19.481638>, <-1.048870, -3.238094, 19.481638>, <3.714340, -3.238087, 20.937996>, <3.714340, 0.000004, 20.937996>, 
      <-1.796262, 0.000000, 21.983717>, <-1.796262, -3.238094, 21.983717>, <4.046037, -3.238087, 25.505071>, <4.046037, 0.000004, 25.505071>, 
      <-1.783179, 0.000000, 22.466506>, <-1.783179, -3.238094, 22.466506>, <0.499169, -3.238087, 26.559643>, <0.499169, 0.000004, 26.559643>
    }
  }
  scale <1.0, 1.0, 0.75>
  rotate -168.168213*z
  translate  <-7.907631, -1.319749, -0.647482>
}
#declare MSQ_Right_Leg = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.024712, -1.821627, -20.215164>, <-2.538448, 6.942467, -22.322744>, <2.538448, -3.662667, -39.998264>, <3.052184, -4.863384, -29.334899>, 
      <-2.178045, -1.502058, -8.277265>, <-1.957873, 2.209931, -5.421400>, <3.119023, 2.212705, -5.405003>, <2.898851, -1.851678, -8.380072>, 
      <-3.289968, -0.562696, -2.135154>, <-2.404769, 1.851162, -4.529501>, <2.672127, 2.546272, -4.166936>, <1.786928, -0.213757, -1.945672>, 
      <-3.739119, -0.052967, 0.527273>, <-3.296519, 2.853142, -1.073427>, <1.780377, 3.201436, -0.883862>, <1.337777, 0.122240, 0.630296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.052184, -4.863384, -29.334899>, <3.565920, -6.064100, -18.671535>, <-1.510976, -10.585720, -18.107583>, <-2.024712, -1.821627, -20.215164>, 
      <2.898851, -1.851678, -8.380072>, <2.678678, -5.916060, -11.355140>, <-2.398218, -5.214047, -11.133129>, <-2.178045, -1.502058, -8.277265>, 
      <1.786928, -0.213757, -1.945672>, <0.901729, -2.973787, 0.275592>, <-4.175167, -2.976553, 0.259193>, <-3.289968, -0.562696, -2.135154>, 
      <1.337777, 0.122240, 0.630296>, <0.895177, -2.956957, 2.144454>, <-4.181719, -2.959076, 2.127973>, <-3.739119, -0.052967, 0.527273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.739119, -0.052967, 0.527273>, <-3.296519, 2.853142, -1.073427>, <1.780377, 3.201436, -0.883862>, <1.337777, 0.122240, 0.630296>, 
      <-4.188270, 0.456762, 3.189699>, <-4.188270, 3.855122, 2.382646>, <0.888626, 3.856600, 2.399211>, <0.888626, 0.458237, 3.206264>, 
      <-4.194821, 0.461436, 5.701026>, <-4.194821, 3.686712, 5.413226>, <0.882075, 3.688190, 5.429790>, <0.882075, 0.462910, 5.717590>, 
      <-4.706066, 0.579999, 9.432704>, <-4.706066, 3.811683, 9.288804>, <0.874668, 3.463143, 6.700770>, <0.874668, 0.231455, 6.844670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.337777, 0.122240, 0.630296>, <0.895177, -2.956957, 2.144454>, <-4.181719, -2.959076, 2.127973>, <-3.739119, -0.052967, 0.527273>, 
      <0.888626, 0.458237, 3.206264>, <0.888626, -2.940127, 4.013317>, <-4.188270, -2.941598, 3.996752>, <-4.188270, 0.456762, 3.189699>, 
      <0.882075, 0.462910, 5.717590>, <0.882075, -2.762369, 6.005391>, <-4.194821, -2.763840, 5.988826>, <-4.194821, 0.461436, 5.701026>, 
      <0.874668, 0.231455, 6.844670>, <0.874668, -3.000232, 6.988570>, <-4.706066, -2.651684, 9.576604>, <-4.706066, 0.579999, 9.432704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.706066, 0.579999, 9.432704>, <-4.706066, 3.811683, 9.288804>, <0.874668, 3.463143, 6.700770>, <0.874668, 0.231455, 6.844670>, 
      <-5.217311, 0.698562, 13.164382>, <-5.217311, 3.936654, 13.164382>, <0.867261, 3.238095, 7.971750>, <0.867261, 0.000000, 7.971750>, 
      <-4.012637, 0.698562, 15.477700>, <-4.012637, 3.936654, 15.477700>, <1.925154, 3.238095, 13.954610>, <1.925154, 0.000000, 13.954610>, 
      <-4.273426, 0.349283, 18.585412>, <-4.273426, 3.587374, 18.585412>, <2.858418, 3.238095, 16.546233>, <2.858418, 0.000000, 16.546233>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.874668, 0.231455, 6.844670>, <0.874668, -3.000232, 6.988570>, <-4.706066, -2.651684, 9.576604>, <-4.706066, 0.579999, 9.432704>, 
      <0.867261, 0.000000, 7.971750>, <0.867261, -3.238094, 7.971750>, <-5.217311, -2.539529, 13.164382>, <-5.217311, 0.698562, 13.164382>, 
      <1.925154, 0.000000, 13.954610>, <1.925154, -3.238094, 13.954610>, <-4.012637, -2.539529, 15.477700>, <-4.012637, 0.698562, 15.477700>, 
      <2.858418, 0.000000, 16.546233>, <2.858418, -3.238094, 16.546233>, <-4.273426, -2.888808, 18.585412>, <-4.273426, 0.349283, 18.585412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.273426, 0.349283, 18.585412>, <-4.273426, 3.587374, 18.585412>, <2.858418, 3.238095, 16.546233>, <2.858418, 0.000000, 16.546233>, 
      <-4.534215, 0.000004, 21.693124>, <-4.534215, 3.238095, 21.693124>, <3.791681, 3.238095, 19.137856>, <3.791681, 0.000000, 19.137856>, 
      <-4.217118, 0.000004, 26.261237>, <-4.217118, 3.238095, 26.261237>, <1.068866, 3.238095, 21.949536>, <1.068866, 0.000000, 21.949536>, 
      <-0.556810, 0.000004, 26.803944>, <-0.556810, 3.238095, 26.803944>, <1.124147, 3.238095, 22.429328>, <1.124147, 0.000000, 22.429328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.858418, 0.000000, 16.546233>, <2.858418, -3.238094, 16.546233>, <-4.273426, -2.888808, 18.585412>, <-4.273426, 0.349283, 18.585412>, 
      <3.791681, 0.000000, 19.137856>, <3.791681, -3.238094, 19.137856>, <-4.534215, -3.238087, 21.693124>, <-4.534215, 0.000004, 21.693124>, 
      <1.068866, 0.000000, 21.949536>, <1.068866, -3.238094, 21.949536>, <-4.217118, -3.238087, 26.261237>, <-4.217118, 0.000004, 26.261237>, 
      <1.124147, 0.000000, 22.429328>, <1.124147, -3.238094, 22.429328>, <-0.556810, -3.238087, 26.803944>, <-0.556810, 0.000004, 26.803944>
    }
  }
  scale <0.85, 0.85, 0.6375>
  rotate <1.749755, -0.448285, -157.988495>
  translate  <1.273406, -0.822172, -18.445121>
}
#declare MSQ_Left_Leg = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.024712, -1.821627, -20.215164>, <2.538448, 6.942467, -22.322744>, <-2.538448, -3.662667, -39.998264>, <-3.052184, -4.863384, -29.334899>, 
      <2.178045, -1.502058, -8.277265>, <1.957873, 2.209931, -5.421400>, <-3.119023, 2.212705, -5.405003>, <-2.898851, -1.851678, -8.380072>, 
      <3.289968, -0.562696, -2.135154>, <2.404769, 1.851162, -4.529501>, <-2.672127, 2.546272, -4.166936>, <-1.786928, -0.213757, -1.945672>, 
      <3.739119, -0.052967, 0.527273>, <3.296519, 2.853142, -1.073427>, <-1.780377, 3.201436, -0.883862>, <-1.337777, 0.122240, 0.630296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.052184, -4.863384, -29.334899>, <-3.565920, -6.064100, -18.671535>, <1.510976, -10.585720, -18.107583>, <2.024712, -1.821627, -20.215164>, 
      <-2.898851, -1.851678, -8.380072>, <-2.678678, -5.916060, -11.355140>, <2.398218, -5.214047, -11.133129>, <2.178045, -1.502058, -8.277265>, 
      <-1.786928, -0.213757, -1.945672>, <-0.901729, -2.973787, 0.275592>, <4.175167, -2.976553, 0.259193>, <3.289968, -0.562696, -2.135154>, 
      <-1.337777, 0.122240, 0.630296>, <-0.895177, -2.956957, 2.144454>, <4.181719, -2.959076, 2.127973>, <3.739119, -0.052967, 0.527273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.739119, -0.052967, 0.527273>, <3.296519, 2.853142, -1.073427>, <-1.780377, 3.201436, -0.883862>, <-1.337777, 0.122240, 0.630296>, 
      <4.188270, 0.456762, 3.189699>, <4.188270, 3.855122, 2.382646>, <-0.888626, 3.856600, 2.399211>, <-0.888626, 0.458237, 3.206264>, 
      <4.194821, 0.461436, 5.701026>, <4.194821, 3.686712, 5.413226>, <-0.882075, 3.688190, 5.429790>, <-0.882075, 0.462910, 5.717590>, 
      <4.706066, 0.579999, 9.432704>, <4.706066, 3.811683, 9.288804>, <-0.874668, 3.463143, 6.700770>, <-0.874668, 0.231455, 6.844670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.337777, 0.122240, 0.630296>, <-0.895177, -2.956957, 2.144454>, <4.181719, -2.959076, 2.127973>, <3.739119, -0.052967, 0.527273>, 
      <-0.888626, 0.458237, 3.206264>, <-0.888626, -2.940127, 4.013317>, <4.188270, -2.941598, 3.996752>, <4.188270, 0.456762, 3.189699>, 
      <-0.882075, 0.462910, 5.717590>, <-0.882075, -2.762369, 6.005391>, <4.194821, -2.763840, 5.988826>, <4.194821, 0.461436, 5.701026>, 
      <-0.874668, 0.231455, 6.844670>, <-0.874668, -3.000232, 6.988570>, <4.706066, -2.651684, 9.576604>, <4.706066, 0.579999, 9.432704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.706066, 0.579999, 9.432704>, <4.706066, 3.811683, 9.288804>, <-0.874668, 3.463143, 6.700770>, <-0.874668, 0.231455, 6.844670>, 
      <5.217311, 0.698562, 13.164382>, <5.217311, 3.936654, 13.164382>, <-0.867261, 3.238095, 7.971750>, <-0.867261, 0.000000, 7.971750>, 
      <4.012637, 0.698562, 15.477700>, <4.012637, 3.936654, 15.477700>, <-1.925154, 3.238095, 13.954610>, <-1.925154, 0.000000, 13.954610>, 
      <4.273426, 0.349283, 18.585412>, <4.273426, 3.587374, 18.585412>, <-2.858418, 3.238095, 16.546233>, <-2.858418, 0.000000, 16.546233>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.874668, 0.231455, 6.844670>, <-0.874668, -3.000232, 6.988570>, <4.706066, -2.651684, 9.576604>, <4.706066, 0.579999, 9.432704>, 
      <-0.867261, 0.000000, 7.971750>, <-0.867261, -3.238094, 7.971750>, <5.217311, -2.539529, 13.164382>, <5.217311, 0.698562, 13.164382>, 
      <-1.925154, 0.000000, 13.954610>, <-1.925154, -3.238094, 13.954610>, <4.012637, -2.539529, 15.477700>, <4.012637, 0.698562, 15.477700>, 
      <-2.858418, 0.000000, 16.546233>, <-2.858418, -3.238094, 16.546233>, <4.273426, -2.888808, 18.585412>, <4.273426, 0.349283, 18.585412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.273426, 0.349283, 18.585412>, <4.273426, 3.587374, 18.585412>, <-2.858418, 3.238095, 16.546233>, <-2.858418, 0.000000, 16.546233>, 
      <4.534215, 0.000004, 21.693124>, <4.534215, 3.238095, 21.693124>, <-3.791681, 3.238095, 19.137856>, <-3.791681, 0.000000, 19.137856>, 
      <4.217118, 0.000004, 26.261237>, <4.217118, 3.238095, 26.261237>, <-1.068866, 3.238095, 21.949536>, <-1.068866, 0.000000, 21.949536>, 
      <0.556810, 0.000004, 26.803944>, <0.556810, 3.238095, 26.803944>, <-1.124147, 3.238095, 22.429328>, <-1.124147, 0.000000, 22.429328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.858418, 0.000000, 16.546233>, <-2.858418, -3.238094, 16.546233>, <4.273426, -2.888808, 18.585412>, <4.273426, 0.349283, 18.585412>, 
      <-3.791681, 0.000000, 19.137856>, <-3.791681, -3.238094, 19.137856>, <4.534215, -3.238087, 21.693124>, <4.534215, 0.000004, 21.693124>, 
      <-1.068866, 0.000000, 21.949536>, <-1.068866, -3.238094, 21.949536>, <4.217118, -3.238087, 26.261237>, <4.217118, 0.000004, 26.261237>, 
      <-1.124147, 0.000000, 22.429328>, <-1.124147, -3.238094, 22.429328>, <0.556810, -3.238087, 26.803944>, <0.556810, 0.000004, 26.803944>
    }
  }
  scale <0.85, 0.85, 0.6375>
  rotate <6.962909, -1.454759, -168.256729>
  translate  <-2.78223, -0.879592, -17.192662>
}
#declare MSQ_Limbs = union {
  object { MSQ_Right_Arm }
  object { MSQ_Left_Arm }
  object { MSQ_Right_Leg }
  object { MSQ_Left_Leg }
  material {
    MEP_Black_Clothes
  }
}
#declare MSQ_Cape = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.277417, -12.110594, 7.265643>, <-6.583813, 9.683968, 13.024421>, <-0.637369, 23.097546, 2.402393>, <2.360066, 12.257687, 6.497880>, 
      <-6.292488, -1.022873, 10.147185>, <-6.403294, -2.552879, 9.740532>, <-1.123593, -1.706234, 6.930848>, <1.593274, -1.980789, 7.409758>, 
      <-10.330738, -4.946553, 4.478506>, <-4.947510, 0.268636, 4.335345>, <-2.366782, -0.005919, 4.178941>, <0.696601, 6.215787, 7.175648>, 
      <-9.680508, -8.100785, 1.495755>, <-5.043136, -0.101651, 0.312809>, <-2.580728, 0.274555, 0.156404>, <0.407564, 7.081355, 2.952601>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-9.680508, -8.100785, 1.495755>, <-5.043136, -0.101651, 0.312809>, <-2.580728, 0.274555, 0.156404>, <0.407564, 7.081355, 2.952601>, 
      <-9.030278, -11.255018, -1.486996>, <-5.138762, -0.471937, -3.709728>, <-2.794674, 0.555029, -3.866132>, <0.118526, 7.946922, -1.270447>, 
      <-16.071542, -8.599181, -4.309932>, <-16.401093, 2.452564, -8.152026>, <-11.403853, 0.835502, -8.308431>, <4.379931, 28.637745, -13.666888>, 
      <-13.561441, -10.494901, -16.161578>, <-30.493222, -22.865963, -59.669003>, <-14.125816, 20.117661, -56.680780>, <-8.133375, 12.241511, -56.371890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.360066, 12.257687, 6.497880>, <5.357501, 1.417828, 10.593366>, <18.658042, -2.035291, 7.607545>, <1.604975, -10.547959, 6.792688>, 
      <1.593274, -1.980789, 7.409758>, <4.310141, -2.255343, 7.888669>, <5.589348, -10.681144, 5.460616>, <12.550704, -18.773083, 2.377155>, 
      <0.696601, 6.215787, 7.175648>, <3.759985, 12.437492, 10.172356>, <5.375402, -0.829583, 3.709728>, <12.124327, -1.104138, 1.750860>, 
      <0.407564, 7.081355, 2.952601>, <3.395855, 13.888154, 5.748797>, <18.926773, 3.469579, 6.729053>, <20.593405, 3.770385, 1.597929>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.407564, 7.081355, 2.952601>, <3.395855, 13.888154, 5.748797>, <18.926773, 3.469579, 6.729053>, <20.593405, 3.770385, 1.597929>, 
      <0.118526, 7.946922, -1.270447>, <3.031726, 15.338816, 1.325238>, <32.478143, 7.768741, 9.748379>, <29.062483, 8.644909, 1.444999>, 
      <4.379931, 28.637745, -13.666888>, <20.163714, 56.439987, -19.025344>, <30.538955, 28.935136, -7.907849>, <33.221972, 15.635680, -21.049706>, 
      <-8.133375, 12.241511, -56.371890>, <-2.140934, 4.365362, -56.063001>, <42.087238, 22.983625, -55.680389>, <24.643593, -19.727784, -59.498640>
    }
  }
  material {
    MEP_Red_Cape
  }
  rotate <11.272867, 1.508694, -179.393646>
  translate  <0.873204, -6.338812, 15.73063>
}
#declare MSQ_Torso = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.162508, -1.111903, -5.615051>, <-3.171194, -3.995647, -5.938620>, <6.302522, -6.463964, -5.849699>, <6.104485, -0.746810, -3.337280>, 
      <-5.738685, -1.495741, 1.188732>, <-0.457401, -1.642461, 2.125196>, <5.119323, -9.665499, 1.951306>, <5.875971, -1.695490, 1.723111>, 
      <-6.035546, -0.467611, 2.804728>, <-0.457401, -1.642461, 4.125196>, <5.560802, -10.705998, 4.820755>, <6.457251, -1.247306, 3.579985>, 
      <-6.247689, -1.936423, 5.510246>, <-0.457401, -1.642461, 6.125196>, <4.609924, -8.464923, 6.255613>, <6.361291, -0.031814, 5.414530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.104485, -0.746810, -3.337280>, <5.906449, 4.970344, -0.824862>, <-9.153823, 1.771841, -5.291482>, <-6.162508, -1.111903, -5.615051>, 
      <5.875971, -1.695490, 1.723111>, <6.632619, 6.274518, 1.494917>, <-11.019970, -1.349022, 0.252269>, <-5.738685, -1.495741, 1.188732>, 
      <6.457251, -1.247306, 3.579985>, <7.353701, 8.211385, 2.339214>, <-11.613691, 0.707238, 1.484260>, <-6.035546, -0.467611, 2.804728>, 
      <6.361291, -0.031814, 5.414530>, <8.112658, 8.401294, 4.573447>, <-12.037977, -2.230386, 4.895297>, <-6.247689, -1.936423, 5.510246>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.247689, -1.936423, 5.510246>, <-0.457401, -1.642461, 6.125196>, <4.609924, -8.464923, 6.255613>, <6.361291, -0.031814, 5.414530>, 
      <-6.459832, -3.405235, 8.215764>, <-0.457401, -1.642461, 8.125196>, <3.659045, -6.223849, 7.690471>, <6.265330, 1.183678, 7.249075>, 
      <-2.585944, 2.056594, 10.383313>, <-0.457401, -1.729405, 10.299085>, <3.421325, -6.265482, 8.994912>, <1.881738, -2.335961, 9.560054>, 
      <-4.634996, 0.587538, 11.997331>, <-0.457401, -1.685933, 12.212141>, <3.709985, -8.149611, 11.128685>, <4.373952, -0.698139, 11.303162>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.361291, -0.031814, 5.414530>, <8.112658, 8.401294, 4.573447>, <-12.037977, -2.230386, 4.895297>, <-6.247689, -1.936423, 5.510246>, 
      <6.265330, 1.183678, 7.249075>, <8.871616, 8.591204, 6.807680>, <-12.462262, -5.168010, 8.306333>, <-6.459832, -3.405235, 8.215764>, 
      <1.881738, -2.335961, 9.560054>, <0.342150, 1.593560, 10.125196>, <-4.714487, 5.842593, 10.467540>, <-2.585944, 2.056594, 10.383313>, 
      <4.373952, -0.698139, 11.303162>, <5.037920, 6.753333, 11.477638>, <-8.812591, 2.861010, 11.782522>, <-4.634996, 0.587538, 11.997331>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.634996, 0.587538, 11.997331>, <-0.457401, -1.685933, 12.212141>, <3.709985, -8.149611, 11.128685>, <4.373952, -0.698139, 11.303162>, 
      <-6.684048, -0.881517, 13.611350>, <-0.457401, -1.642461, 14.125196>, <3.998644, -10.033741, 13.262459>, <6.866167, 0.939682, 13.046270>, 
      <-6.803776, 0.742061, 16.527148>, <-0.457401, -1.642461, 16.125196>, <4.202404, -10.995493, 17.476166>, <7.007232, -1.437356, 16.713736>, 
      <-7.104169, -1.199833, 18.453871>, <-0.457401, -1.642461, 18.125196>, <2.793066, -5.928385, 18.800681>, <7.207050, 0.852674, 18.589732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.373952, -0.698139, 11.303162>, <5.037920, 6.753333, 11.477638>, <-8.812591, 2.861010, 11.782522>, <-4.634996, 0.587538, 11.997331>, 
      <6.866167, 0.939682, 13.046270>, <9.733691, 11.913106, 12.830081>, <-12.910695, -0.120573, 13.097505>, <-6.684048, -0.881517, 13.611350>, 
      <7.007232, -1.437356, 16.713736>, <9.812061, 8.120781, 15.951306>, <-13.150150, 3.126583, 16.929100>, <-6.803776, 0.742061, 16.527148>, 
      <7.207050, 0.852674, 18.589732>, <11.621034, 7.633733, 18.378783>, <-13.750936, -0.757205, 18.782547>, <-7.104169, -1.199833, 18.453871>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.104169, -1.199833, 18.453871>, <-0.457401, -1.642461, 18.125196>, <2.793066, -5.928385, 18.800681>, <7.207050, 0.852674, 18.589732>, 
      <-7.404562, -3.141727, 20.380595>, <-0.457401, -1.642461, 20.125196>, <1.383728, -0.861277, 20.125196>, <7.406867, 3.142703, 20.465728>, 
      <-1.350394, 0.241394, 22.168668>, <-0.322260, -1.440970, 22.125196>, <1.663129, -0.878727, 22.125196>, <1.545667, 1.641811, 22.125196>, 
      <-3.218493, 0.216282, 22.932661>, <-2.115036, -3.790423, 24.609309>, <4.258094, -1.545679, 24.125196>, <2.687628, 3.197383, 22.821022>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.207050, 0.852674, 18.589732>, <11.621034, 7.633733, 18.378783>, <-13.750936, -0.757205, 18.782547>, <-7.104169, -1.199833, 18.453871>, 
      <7.406867, 3.142703, 20.465728>, <13.430007, 7.146684, 20.806260>, <-14.351722, -4.640994, 20.635994>, <-7.404562, -3.141727, 20.380595>, 
      <1.545667, 1.641811, 22.125196>, <1.428204, 4.162350, 22.125196>, <-2.378529, 1.923757, 22.212141>, <-1.350394, 0.241394, 22.168668>, 
      <2.687628, 3.197383, 22.821022>, <1.117162, 7.940445, 21.516848>, <-4.321950, 4.222988, 21.256013>, <-3.218493, 0.216282, 22.932661>
    }
  }
  material {
    MEP_Harlequen_Suit
  }
}
#declare MSQ_Clothing = union {
  object { MSQ_Limbs }
  object { MSQ_Cape }
  object { MSQ_Torso }
}
#declare MSQ_Red_Death = union {
  object { MSQ_Clothing }
  plane { // Masque_Skull
    z,0
    material {
      MEP_Skull
    }
    scale <7.021277, 11.0, 0.00001>
    rotate <106.971268, -5.038879, 167.332748>
    translate  <2.537818, 1.345029, 22.146767>
  }
  no_shadow
  rotate <-33.919998, 18.945, -64.230003>
  translate  <49.437975, 315.848237, 40.854261>
}
union { // Masque_Group
  object { MSQ_Red_Death }
  rotate <0.209413, -0.0, -0.11476>
  translate  <-1.955664, -6.609885, 4.725313>
}


